<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMCHotel ArrayType
 * @subpackage Arrays
 */
class ArrayOfMCHotel extends AbstractStructArrayBase
{
    /**
     * The MCHotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MCHotel[]
     */
    public $MCHotel;
    /**
     * Constructor method for ArrayOfMCHotel
     * @uses ArrayOfMCHotel::setMCHotel()
     * @param \StructType\MCHotel[] $mCHotel
     */
    public function __construct(array $mCHotel = array())
    {
        $this
            ->setMCHotel($mCHotel);
    }
    /**
     * Get MCHotel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MCHotel[]|null
     */
    public function getMCHotel()
    {
        return isset($this->MCHotel) ? $this->MCHotel : null;
    }
    /**
     * Set MCHotel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MCHotel[] $mCHotel
     * @return \ArrayType\ArrayOfMCHotel
     */
    public function setMCHotel(array $mCHotel = array())
    {
        foreach ($mCHotel as $arrayOfMCHotelMCHotelItem) {
            // validation for constraint: itemType
            if (!$arrayOfMCHotelMCHotelItem instanceof \StructType\MCHotel) {
                throw new \InvalidArgumentException(sprintf('The MCHotel property can only contain items of \StructType\MCHotel, "%s" given', is_object($arrayOfMCHotelMCHotelItem) ? get_class($arrayOfMCHotelMCHotelItem) : gettype($arrayOfMCHotelMCHotelItem)), __LINE__);
            }
        }
        if (is_null($mCHotel) || (is_array($mCHotel) && empty($mCHotel))) {
            unset($this->MCHotel);
        } else {
            $this->MCHotel = $mCHotel;
        }
        return $this;
    }
    /**
     * Add item to MCHotel value
     * @throws \InvalidArgumentException
     * @param \StructType\MCHotel $item
     * @return \ArrayType\ArrayOfMCHotel
     */
    public function addToMCHotel(\StructType\MCHotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MCHotel) {
            throw new \InvalidArgumentException(sprintf('The MCHotel property can only contain items of \StructType\MCHotel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MCHotel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MCHotel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MCHotel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MCHotel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MCHotel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MCHotel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MCHotel
     */
    public function getAttributeName()
    {
        return 'MCHotel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMCHotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
