<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHotel ArrayType
 * @subpackage Arrays
 */
class ArrayOfHotel extends AbstractStructArrayBase
{
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hotel[]
     */
    public $Hotel;
    /**
     * Constructor method for ArrayOfHotel
     * @uses ArrayOfHotel::setHotel()
     * @param \StructType\Hotel[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hotel[]|null
     */
    public function getHotel()
    {
        return isset($this->Hotel) ? $this->Hotel : null;
    }
    /**
     * Set Hotel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel[] $hotel
     * @return \ArrayType\ArrayOfHotel
     */
    public function setHotel(array $hotel = array())
    {
        foreach ($hotel as $arrayOfHotelHotelItem) {
            // validation for constraint: itemType
            if (!$arrayOfHotelHotelItem instanceof \StructType\Hotel) {
                throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\Hotel, "%s" given', is_object($arrayOfHotelHotelItem) ? get_class($arrayOfHotelHotelItem) : gettype($arrayOfHotelHotelItem)), __LINE__);
            }
        }
        if (is_null($hotel) || (is_array($hotel) && empty($hotel))) {
            unset($this->Hotel);
        } else {
            $this->Hotel = $hotel;
        }
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel $item
     * @return \ArrayType\ArrayOfHotel
     */
    public function addToHotel(\StructType\Hotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\Hotel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Hotel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Hotel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Hotel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Hotel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Hotel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Hotel
     */
    public function getAttributeName()
    {
        return 'Hotel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfHotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
