<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDiningWith ArrayType
 * @subpackage Arrays
 */
class ArrayOfDiningWith extends AbstractStructArrayBase
{
    /**
     * The DiningWith
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DiningWith[]
     */
    public $DiningWith;
    /**
     * Constructor method for ArrayOfDiningWith
     * @uses ArrayOfDiningWith::setDiningWith()
     * @param \StructType\DiningWith[] $diningWith
     */
    public function __construct(array $diningWith = array())
    {
        $this
            ->setDiningWith($diningWith);
    }
    /**
     * Get DiningWith value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiningWith[]|null
     */
    public function getDiningWith()
    {
        return isset($this->DiningWith) ? $this->DiningWith : null;
    }
    /**
     * Set DiningWith value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiningWith[] $diningWith
     * @return \ArrayType\ArrayOfDiningWith
     */
    public function setDiningWith(array $diningWith = array())
    {
        foreach ($diningWith as $arrayOfDiningWithDiningWithItem) {
            // validation for constraint: itemType
            if (!$arrayOfDiningWithDiningWithItem instanceof \StructType\DiningWith) {
                throw new \InvalidArgumentException(sprintf('The DiningWith property can only contain items of \StructType\DiningWith, "%s" given', is_object($arrayOfDiningWithDiningWithItem) ? get_class($arrayOfDiningWithDiningWithItem) : gettype($arrayOfDiningWithDiningWithItem)), __LINE__);
            }
        }
        if (is_null($diningWith) || (is_array($diningWith) && empty($diningWith))) {
            unset($this->DiningWith);
        } else {
            $this->DiningWith = $diningWith;
        }
        return $this;
    }
    /**
     * Add item to DiningWith value
     * @throws \InvalidArgumentException
     * @param \StructType\DiningWith $item
     * @return \ArrayType\ArrayOfDiningWith
     */
    public function addToDiningWith(\StructType\DiningWith $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiningWith) {
            throw new \InvalidArgumentException(sprintf('The DiningWith property can only contain items of \StructType\DiningWith, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DiningWith[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DiningWith|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DiningWith|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DiningWith|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DiningWith|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DiningWith|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DiningWith
     */
    public function getAttributeName()
    {
        return 'DiningWith';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDiningWith
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
