<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCruiseDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfCruiseDocument extends AbstractStructArrayBase
{
    /**
     * The CruiseDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CruiseDocument[]
     */
    public $CruiseDocument;
    /**
     * Constructor method for ArrayOfCruiseDocument
     * @uses ArrayOfCruiseDocument::setCruiseDocument()
     * @param \StructType\CruiseDocument[] $cruiseDocument
     */
    public function __construct(array $cruiseDocument = array())
    {
        $this
            ->setCruiseDocument($cruiseDocument);
    }
    /**
     * Get CruiseDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CruiseDocument[]|null
     */
    public function getCruiseDocument()
    {
        return isset($this->CruiseDocument) ? $this->CruiseDocument : null;
    }
    /**
     * Set CruiseDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseDocument[] $cruiseDocument
     * @return \ArrayType\ArrayOfCruiseDocument
     */
    public function setCruiseDocument(array $cruiseDocument = array())
    {
        foreach ($cruiseDocument as $arrayOfCruiseDocumentCruiseDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfCruiseDocumentCruiseDocumentItem instanceof \StructType\CruiseDocument) {
                throw new \InvalidArgumentException(sprintf('The CruiseDocument property can only contain items of \StructType\CruiseDocument, "%s" given', is_object($arrayOfCruiseDocumentCruiseDocumentItem) ? get_class($arrayOfCruiseDocumentCruiseDocumentItem) : gettype($arrayOfCruiseDocumentCruiseDocumentItem)), __LINE__);
            }
        }
        if (is_null($cruiseDocument) || (is_array($cruiseDocument) && empty($cruiseDocument))) {
            unset($this->CruiseDocument);
        } else {
            $this->CruiseDocument = $cruiseDocument;
        }
        return $this;
    }
    /**
     * Add item to CruiseDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseDocument $item
     * @return \ArrayType\ArrayOfCruiseDocument
     */
    public function addToCruiseDocument(\StructType\CruiseDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CruiseDocument) {
            throw new \InvalidArgumentException(sprintf('The CruiseDocument property can only contain items of \StructType\CruiseDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CruiseDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CruiseDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CruiseDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CruiseDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CruiseDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CruiseDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CruiseDocument
     */
    public function getAttributeName()
    {
        return 'CruiseDocument';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCruiseDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
