<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCruise ArrayType
 * @subpackage Arrays
 */
class ArrayOfCruise extends AbstractStructArrayBase
{
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Cruise[]
     */
    public $Cruise;
    /**
     * Constructor method for ArrayOfCruise
     * @uses ArrayOfCruise::setCruise()
     * @param \StructType\Cruise[] $cruise
     */
    public function __construct(array $cruise = array())
    {
        $this
            ->setCruise($cruise);
    }
    /**
     * Get Cruise value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Cruise[]|null
     */
    public function getCruise()
    {
        return isset($this->Cruise) ? $this->Cruise : null;
    }
    /**
     * Set Cruise value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cruise[] $cruise
     * @return \ArrayType\ArrayOfCruise
     */
    public function setCruise(array $cruise = array())
    {
        foreach ($cruise as $arrayOfCruiseCruiseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCruiseCruiseItem instanceof \StructType\Cruise) {
                throw new \InvalidArgumentException(sprintf('The Cruise property can only contain items of \StructType\Cruise, "%s" given', is_object($arrayOfCruiseCruiseItem) ? get_class($arrayOfCruiseCruiseItem) : gettype($arrayOfCruiseCruiseItem)), __LINE__);
            }
        }
        if (is_null($cruise) || (is_array($cruise) && empty($cruise))) {
            unset($this->Cruise);
        } else {
            $this->Cruise = $cruise;
        }
        return $this;
    }
    /**
     * Add item to Cruise value
     * @throws \InvalidArgumentException
     * @param \StructType\Cruise $item
     * @return \ArrayType\ArrayOfCruise
     */
    public function addToCruise(\StructType\Cruise $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cruise) {
            throw new \InvalidArgumentException(sprintf('The Cruise property can only contain items of \StructType\Cruise, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Cruise[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Cruise|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Cruise|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Cruise|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Cruise|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Cruise|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cruise
     */
    public function getAttributeName()
    {
        return 'Cruise';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCruise
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
