<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfComponent ArrayType
 * @subpackage Arrays
 */
class ArrayOfComponent extends AbstractStructArrayBase
{
    /**
     * The Component
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Component[]
     */
    public $Component;
    /**
     * Constructor method for ArrayOfComponent
     * @uses ArrayOfComponent::setComponent()
     * @param \StructType\Component[] $component
     */
    public function __construct(array $component = array())
    {
        $this
            ->setComponent($component);
    }
    /**
     * Get Component value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Component[]|null
     */
    public function getComponent()
    {
        return isset($this->Component) ? $this->Component : null;
    }
    /**
     * Set Component value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Component[] $component
     * @return \ArrayType\ArrayOfComponent
     */
    public function setComponent(array $component = array())
    {
        foreach ($component as $arrayOfComponentComponentItem) {
            // validation for constraint: itemType
            if (!$arrayOfComponentComponentItem instanceof \StructType\Component) {
                throw new \InvalidArgumentException(sprintf('The Component property can only contain items of \StructType\Component, "%s" given', is_object($arrayOfComponentComponentItem) ? get_class($arrayOfComponentComponentItem) : gettype($arrayOfComponentComponentItem)), __LINE__);
            }
        }
        if (is_null($component) || (is_array($component) && empty($component))) {
            unset($this->Component);
        } else {
            $this->Component = $component;
        }
        return $this;
    }
    /**
     * Add item to Component value
     * @throws \InvalidArgumentException
     * @param \StructType\Component $item
     * @return \ArrayType\ArrayOfComponent
     */
    public function addToComponent(\StructType\Component $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Component) {
            throw new \InvalidArgumentException(sprintf('The Component property can only contain items of \StructType\Component, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Component[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Component|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Component|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Component|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Component|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Component|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Component
     */
    public function getAttributeName()
    {
        return 'Component';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
