<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCity ArrayType
 * @subpackage Arrays
 */
class ArrayOfCity extends AbstractStructArrayBase
{
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\City[]
     */
    public $City;
    /**
     * Constructor method for ArrayOfCity
     * @uses ArrayOfCity::setCity()
     * @param \StructType\City[] $city
     */
    public function __construct(array $city = array())
    {
        $this
            ->setCity($city);
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\City[]|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\City[] $city
     * @return \ArrayType\ArrayOfCity
     */
    public function setCity(array $city = array())
    {
        foreach ($city as $arrayOfCityCityItem) {
            // validation for constraint: itemType
            if (!$arrayOfCityCityItem instanceof \StructType\City) {
                throw new \InvalidArgumentException(sprintf('The City property can only contain items of \StructType\City, "%s" given', is_object($arrayOfCityCityItem) ? get_class($arrayOfCityCityItem) : gettype($arrayOfCityCityItem)), __LINE__);
            }
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Add item to City value
     * @throws \InvalidArgumentException
     * @param \StructType\City $item
     * @return \ArrayType\ArrayOfCity
     */
    public function addToCity(\StructType\City $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\City) {
            throw new \InvalidArgumentException(sprintf('The City property can only contain items of \StructType\City, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->City[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\City|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\City|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\City|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\City|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\City|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string City
     */
    public function getAttributeName()
    {
        return 'City';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
