<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBed ArrayType
 * @subpackage Arrays
 */
class ArrayOfBed extends AbstractStructArrayBase
{
    /**
     * The Bed
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bed[]
     */
    public $Bed;
    /**
     * Constructor method for ArrayOfBed
     * @uses ArrayOfBed::setBed()
     * @param \StructType\Bed[] $bed
     */
    public function __construct(array $bed = array())
    {
        $this
            ->setBed($bed);
    }
    /**
     * Get Bed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bed[]|null
     */
    public function getBed()
    {
        return isset($this->Bed) ? $this->Bed : null;
    }
    /**
     * Set Bed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bed[] $bed
     * @return \ArrayType\ArrayOfBed
     */
    public function setBed(array $bed = array())
    {
        foreach ($bed as $arrayOfBedBedItem) {
            // validation for constraint: itemType
            if (!$arrayOfBedBedItem instanceof \StructType\Bed) {
                throw new \InvalidArgumentException(sprintf('The Bed property can only contain items of \StructType\Bed, "%s" given', is_object($arrayOfBedBedItem) ? get_class($arrayOfBedBedItem) : gettype($arrayOfBedBedItem)), __LINE__);
            }
        }
        if (is_null($bed) || (is_array($bed) && empty($bed))) {
            unset($this->Bed);
        } else {
            $this->Bed = $bed;
        }
        return $this;
    }
    /**
     * Add item to Bed value
     * @throws \InvalidArgumentException
     * @param \StructType\Bed $item
     * @return \ArrayType\ArrayOfBed
     */
    public function addToBed(\StructType\Bed $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bed) {
            throw new \InvalidArgumentException(sprintf('The Bed property can only contain items of \StructType\Bed, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Bed[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Bed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Bed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Bed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Bed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Bed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Bed
     */
    public function getAttributeName()
    {
        return 'Bed';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
