<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelInfo StructType
 * @subpackage Structs
 */
class TravelInfo extends AbstractStructBase
{
    /**
     * The ErpId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErpId;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeStamp;
    /**
     * The InsErpId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InsErpId;
    /**
     * Constructor method for TravelInfo
     * @uses TravelInfo::setErpId()
     * @uses TravelInfo::setTimeStamp()
     * @uses TravelInfo::setInsErpId()
     * @param string $erpId
     * @param string $timeStamp
     * @param string $insErpId
     */
    public function __construct($erpId = null, $timeStamp = null, $insErpId = null)
    {
        $this
            ->setErpId($erpId)
            ->setTimeStamp($timeStamp)
            ->setInsErpId($insErpId);
    }
    /**
     * Get ErpId value
     * @return string|null
     */
    public function getErpId()
    {
        return $this->ErpId;
    }
    /**
     * Set ErpId value
     * @param string $erpId
     * @return \StructType\TravelInfo
     */
    public function setErpId($erpId = null)
    {
        // validation for constraint: string
        if (!is_null($erpId) && !is_string($erpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($erpId)), __LINE__);
        }
        $this->ErpId = $erpId;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\TravelInfo
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get InsErpId value
     * @return string|null
     */
    public function getInsErpId()
    {
        return $this->InsErpId;
    }
    /**
     * Set InsErpId value
     * @param string $insErpId
     * @return \StructType\TravelInfo
     */
    public function setInsErpId($insErpId = null)
    {
        // validation for constraint: string
        if (!is_null($insErpId) && !is_string($insErpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insErpId)), __LINE__);
        }
        $this->InsErpId = $insErpId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
