<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationDetail StructType
 * @subpackage Structs
 */
class TransportationDetail extends AbstractStructBase
{
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Direction;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureLocationType;
    /**
     * The ArrivalLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalLocationType;
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The CarrierName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The CarrierNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierNumber;
    /**
     * The DepartureCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $DepartureCity;
    /**
     * The ArrivalCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $ArrivalCity;
    /**
     * The ClassCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassCode;
    /**
     * The ClassDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassDescription;
    /**
     * The CheckInInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckInInformation
     */
    public $CheckInInformation;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalTime;
    /**
     * Constructor method for TransportationDetail
     * @uses TransportationDetail::setDirection()
     * @uses TransportationDetail::setDepartureDate()
     * @uses TransportationDetail::setArrivalDate()
     * @uses TransportationDetail::setDepartureLocationType()
     * @uses TransportationDetail::setArrivalLocationType()
     * @uses TransportationDetail::setCarrierCode()
     * @uses TransportationDetail::setCarrierName()
     * @uses TransportationDetail::setCarrierNumber()
     * @uses TransportationDetail::setDepartureCity()
     * @uses TransportationDetail::setArrivalCity()
     * @uses TransportationDetail::setClassCode()
     * @uses TransportationDetail::setClassDescription()
     * @uses TransportationDetail::setCheckInInformation()
     * @uses TransportationDetail::setDepartureTime()
     * @uses TransportationDetail::setArrivalTime()
     * @param string $direction
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $departureLocationType
     * @param string $arrivalLocationType
     * @param string $carrierCode
     * @param string $carrierName
     * @param string $carrierNumber
     * @param \StructType\City $departureCity
     * @param \StructType\City $arrivalCity
     * @param string $classCode
     * @param string $classDescription
     * @param \StructType\CheckInInformation $checkInInformation
     * @param string $departureTime
     * @param string $arrivalTime
     */
    public function __construct($direction = null, $departureDate = null, $arrivalDate = null, $departureLocationType = null, $arrivalLocationType = null, $carrierCode = null, $carrierName = null, $carrierNumber = null, \StructType\City $departureCity = null, \StructType\City $arrivalCity = null, $classCode = null, $classDescription = null, \StructType\CheckInInformation $checkInInformation = null, $departureTime = null, $arrivalTime = null)
    {
        $this
            ->setDirection($direction)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setDepartureLocationType($departureLocationType)
            ->setArrivalLocationType($arrivalLocationType)
            ->setCarrierCode($carrierCode)
            ->setCarrierName($carrierName)
            ->setCarrierNumber($carrierNumber)
            ->setDepartureCity($departureCity)
            ->setArrivalCity($arrivalCity)
            ->setClassCode($classCode)
            ->setClassDescription($classDescription)
            ->setCheckInInformation($checkInInformation)
            ->setDepartureTime($departureTime)
            ->setArrivalTime($arrivalTime);
    }
    /**
     * Get Direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\TransportationDetail
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $direction, implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\TransportationDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\TransportationDetail
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureLocationType value
     * @return string
     */
    public function getDepartureLocationType()
    {
        return $this->DepartureLocationType;
    }
    /**
     * Set DepartureLocationType value
     * @uses \EnumType\LocationType::valueIsValid()
     * @uses \EnumType\LocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureLocationType
     * @return \StructType\TransportationDetail
     */
    public function setDepartureLocationType($departureLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationType::valueIsValid($departureLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureLocationType, implode(', ', \EnumType\LocationType::getValidValues())), __LINE__);
        }
        $this->DepartureLocationType = $departureLocationType;
        return $this;
    }
    /**
     * Get ArrivalLocationType value
     * @return string
     */
    public function getArrivalLocationType()
    {
        return $this->ArrivalLocationType;
    }
    /**
     * Set ArrivalLocationType value
     * @uses \EnumType\LocationType::valueIsValid()
     * @uses \EnumType\LocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalLocationType
     * @return \StructType\TransportationDetail
     */
    public function setArrivalLocationType($arrivalLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationType::valueIsValid($arrivalLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalLocationType, implode(', ', \EnumType\LocationType::getValidValues())), __LINE__);
        }
        $this->ArrivalLocationType = $arrivalLocationType;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\TransportationDetail
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\TransportationDetail
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get CarrierNumber value
     * @return string|null
     */
    public function getCarrierNumber()
    {
        return $this->CarrierNumber;
    }
    /**
     * Set CarrierNumber value
     * @param string $carrierNumber
     * @return \StructType\TransportationDetail
     */
    public function setCarrierNumber($carrierNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carrierNumber) && !is_string($carrierNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierNumber)), __LINE__);
        }
        $this->CarrierNumber = $carrierNumber;
        return $this;
    }
    /**
     * Get DepartureCity value
     * @return \StructType\City|null
     */
    public function getDepartureCity()
    {
        return $this->DepartureCity;
    }
    /**
     * Set DepartureCity value
     * @param \StructType\City $departureCity
     * @return \StructType\TransportationDetail
     */
    public function setDepartureCity(\StructType\City $departureCity = null)
    {
        $this->DepartureCity = $departureCity;
        return $this;
    }
    /**
     * Get ArrivalCity value
     * @return \StructType\City|null
     */
    public function getArrivalCity()
    {
        return $this->ArrivalCity;
    }
    /**
     * Set ArrivalCity value
     * @param \StructType\City $arrivalCity
     * @return \StructType\TransportationDetail
     */
    public function setArrivalCity(\StructType\City $arrivalCity = null)
    {
        $this->ArrivalCity = $arrivalCity;
        return $this;
    }
    /**
     * Get ClassCode value
     * @return string|null
     */
    public function getClassCode()
    {
        return $this->ClassCode;
    }
    /**
     * Set ClassCode value
     * @param string $classCode
     * @return \StructType\TransportationDetail
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: string
        if (!is_null($classCode) && !is_string($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classCode)), __LINE__);
        }
        $this->ClassCode = $classCode;
        return $this;
    }
    /**
     * Get ClassDescription value
     * @return string|null
     */
    public function getClassDescription()
    {
        return $this->ClassDescription;
    }
    /**
     * Set ClassDescription value
     * @param string $classDescription
     * @return \StructType\TransportationDetail
     */
    public function setClassDescription($classDescription = null)
    {
        // validation for constraint: string
        if (!is_null($classDescription) && !is_string($classDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classDescription)), __LINE__);
        }
        $this->ClassDescription = $classDescription;
        return $this;
    }
    /**
     * Get CheckInInformation value
     * @return \StructType\CheckInInformation|null
     */
    public function getCheckInInformation()
    {
        return $this->CheckInInformation;
    }
    /**
     * Set CheckInInformation value
     * @param \StructType\CheckInInformation $checkInInformation
     * @return \StructType\TransportationDetail
     */
    public function setCheckInInformation(\StructType\CheckInInformation $checkInInformation = null)
    {
        $this->CheckInInformation = $checkInInformation;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\TransportationDetail
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\TransportationDetail
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
