<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServices StructType
 * @subpackage Structs
 */
class SpecialServices extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The ServicePriceCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServicePriceCharges;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The TypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDescription;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The CruiseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseCode;
    /**
     * The CabinNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CabinNumber;
    /**
     * The SSVType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SSVType
     */
    public $SSVType;
    /**
     * The SSVRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SSVRates
     */
    public $SSVRates;
    /**
     * The SSVRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SSVRules
     */
    public $SSVRules;
    /**
     * The SSVCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSVCategory;
    /**
     * The SSVAvlLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSVAvlLocation;
    /**
     * The SSVSellable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SSVSellable
     */
    public $SSVSellable;
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemId;
    /**
     * The PaxId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxId;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Delivery;
    /**
     * The GiftText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GiftText;
    /**
     * The Instruction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Instruction;
    /**
     * The PortConfirmation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PortConfirmation;
    /**
     * The VaucherControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VaucherControl;
    /**
     * The SSVCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSVCurrency;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * The AdultAgeLimits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdultAgeLimits;
    /**
     * The ChildAgeLimits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChildAgeLimits;
    /**
     * The SSVAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SSVAvailable
     */
    public $SSVAvailable;
    /**
     * The PrintOnConfLetter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrintOnConfLetter
     */
    public $PrintOnConfLetter;
    /**
     * The VoucherInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VoucherInfo
     */
    public $VoucherInfo;
    /**
     * The IsAuto
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsAuto;
    /**
     * The GuestSequenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuestSequenceNumber;
    /**
     * Constructor method for SpecialServices
     * @uses SpecialServices::setDate()
     * @uses SpecialServices::setEndDate()
     * @uses SpecialServices::setServicePriceCharges()
     * @uses SpecialServices::setAmount()
     * @uses SpecialServices::setCode()
     * @uses SpecialServices::setType()
     * @uses SpecialServices::setDescription()
     * @uses SpecialServices::setName()
     * @uses SpecialServices::setTypeDescription()
     * @uses SpecialServices::setStatusCode()
     * @uses SpecialServices::setCruiseCode()
     * @uses SpecialServices::setCabinNumber()
     * @uses SpecialServices::setSSVType()
     * @uses SpecialServices::setSSVRates()
     * @uses SpecialServices::setSSVRules()
     * @uses SpecialServices::setSSVCategory()
     * @uses SpecialServices::setSSVAvlLocation()
     * @uses SpecialServices::setSSVSellable()
     * @uses SpecialServices::setItemId()
     * @uses SpecialServices::setPaxId()
     * @uses SpecialServices::setDelivery()
     * @uses SpecialServices::setGiftText()
     * @uses SpecialServices::setInstruction()
     * @uses SpecialServices::setPortConfirmation()
     * @uses SpecialServices::setVaucherControl()
     * @uses SpecialServices::setSSVCurrency()
     * @uses SpecialServices::setQuantity()
     * @uses SpecialServices::setAdultAgeLimits()
     * @uses SpecialServices::setChildAgeLimits()
     * @uses SpecialServices::setSSVAvailable()
     * @uses SpecialServices::setPrintOnConfLetter()
     * @uses SpecialServices::setVoucherInfo()
     * @uses SpecialServices::setIsAuto()
     * @uses SpecialServices::setGuestSequenceNumber()
     * @param string $date
     * @param string $endDate
     * @param string $servicePriceCharges
     * @param float $amount
     * @param string $code
     * @param string $type
     * @param string $description
     * @param string $name
     * @param string $typeDescription
     * @param string $statusCode
     * @param string $cruiseCode
     * @param string $cabinNumber
     * @param \StructType\SSVType $sSVType
     * @param \StructType\SSVRates $sSVRates
     * @param \StructType\SSVRules $sSVRules
     * @param string $sSVCategory
     * @param string $sSVAvlLocation
     * @param \StructType\SSVSellable $sSVSellable
     * @param string $itemId
     * @param string $paxId
     * @param string $delivery
     * @param string $giftText
     * @param string $instruction
     * @param string $portConfirmation
     * @param string $vaucherControl
     * @param string $sSVCurrency
     * @param string $quantity
     * @param string $adultAgeLimits
     * @param string $childAgeLimits
     * @param \StructType\SSVAvailable $sSVAvailable
     * @param \StructType\PrintOnConfLetter $printOnConfLetter
     * @param \StructType\VoucherInfo $voucherInfo
     * @param string $isAuto
     * @param string $guestSequenceNumber
     */
    public function __construct($date = null, $endDate = null, $servicePriceCharges = null, $amount = null, $code = null, $type = null, $description = null, $name = null, $typeDescription = null, $statusCode = null, $cruiseCode = null, $cabinNumber = null, \StructType\SSVType $sSVType = null, \StructType\SSVRates $sSVRates = null, \StructType\SSVRules $sSVRules = null, $sSVCategory = null, $sSVAvlLocation = null, \StructType\SSVSellable $sSVSellable = null, $itemId = null, $paxId = null, $delivery = null, $giftText = null, $instruction = null, $portConfirmation = null, $vaucherControl = null, $sSVCurrency = null, $quantity = null, $adultAgeLimits = null, $childAgeLimits = null, \StructType\SSVAvailable $sSVAvailable = null, \StructType\PrintOnConfLetter $printOnConfLetter = null, \StructType\VoucherInfo $voucherInfo = null, $isAuto = null, $guestSequenceNumber = null)
    {
        $this
            ->setDate($date)
            ->setEndDate($endDate)
            ->setServicePriceCharges($servicePriceCharges)
            ->setAmount($amount)
            ->setCode($code)
            ->setType($type)
            ->setDescription($description)
            ->setName($name)
            ->setTypeDescription($typeDescription)
            ->setStatusCode($statusCode)
            ->setCruiseCode($cruiseCode)
            ->setCabinNumber($cabinNumber)
            ->setSSVType($sSVType)
            ->setSSVRates($sSVRates)
            ->setSSVRules($sSVRules)
            ->setSSVCategory($sSVCategory)
            ->setSSVAvlLocation($sSVAvlLocation)
            ->setSSVSellable($sSVSellable)
            ->setItemId($itemId)
            ->setPaxId($paxId)
            ->setDelivery($delivery)
            ->setGiftText($giftText)
            ->setInstruction($instruction)
            ->setPortConfirmation($portConfirmation)
            ->setVaucherControl($vaucherControl)
            ->setSSVCurrency($sSVCurrency)
            ->setQuantity($quantity)
            ->setAdultAgeLimits($adultAgeLimits)
            ->setChildAgeLimits($childAgeLimits)
            ->setSSVAvailable($sSVAvailable)
            ->setPrintOnConfLetter($printOnConfLetter)
            ->setVoucherInfo($voucherInfo)
            ->setIsAuto($isAuto)
            ->setGuestSequenceNumber($guestSequenceNumber);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\SpecialServices
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\SpecialServices
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ServicePriceCharges value
     * @return string
     */
    public function getServicePriceCharges()
    {
        return $this->ServicePriceCharges;
    }
    /**
     * Set ServicePriceCharges value
     * @uses \EnumType\ServicePriceCharges::valueIsValid()
     * @uses \EnumType\ServicePriceCharges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePriceCharges
     * @return \StructType\SpecialServices
     */
    public function setServicePriceCharges($servicePriceCharges = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServicePriceCharges::valueIsValid($servicePriceCharges)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicePriceCharges, implode(', ', \EnumType\ServicePriceCharges::getValidValues())), __LINE__);
        }
        $this->ServicePriceCharges = $servicePriceCharges;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SpecialServices
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SpecialServices
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SpecialServices
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SpecialServices
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SpecialServices
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get TypeDescription value
     * @return string|null
     */
    public function getTypeDescription()
    {
        return $this->TypeDescription;
    }
    /**
     * Set TypeDescription value
     * @param string $typeDescription
     * @return \StructType\SpecialServices
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDescription)), __LINE__);
        }
        $this->TypeDescription = $typeDescription;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\SpecialServices
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\SpecialServices
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Get CabinNumber value
     * @return string|null
     */
    public function getCabinNumber()
    {
        return $this->CabinNumber;
    }
    /**
     * Set CabinNumber value
     * @param string $cabinNumber
     * @return \StructType\SpecialServices
     */
    public function setCabinNumber($cabinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cabinNumber) && !is_string($cabinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinNumber)), __LINE__);
        }
        $this->CabinNumber = $cabinNumber;
        return $this;
    }
    /**
     * Get SSVType value
     * @return \StructType\SSVType|null
     */
    public function getSSVType()
    {
        return $this->SSVType;
    }
    /**
     * Set SSVType value
     * @param \StructType\SSVType $sSVType
     * @return \StructType\SpecialServices
     */
    public function setSSVType(\StructType\SSVType $sSVType = null)
    {
        $this->SSVType = $sSVType;
        return $this;
    }
    /**
     * Get SSVRates value
     * @return \StructType\SSVRates|null
     */
    public function getSSVRates()
    {
        return $this->SSVRates;
    }
    /**
     * Set SSVRates value
     * @param \StructType\SSVRates $sSVRates
     * @return \StructType\SpecialServices
     */
    public function setSSVRates(\StructType\SSVRates $sSVRates = null)
    {
        $this->SSVRates = $sSVRates;
        return $this;
    }
    /**
     * Get SSVRules value
     * @return \StructType\SSVRules|null
     */
    public function getSSVRules()
    {
        return $this->SSVRules;
    }
    /**
     * Set SSVRules value
     * @param \StructType\SSVRules $sSVRules
     * @return \StructType\SpecialServices
     */
    public function setSSVRules(\StructType\SSVRules $sSVRules = null)
    {
        $this->SSVRules = $sSVRules;
        return $this;
    }
    /**
     * Get SSVCategory value
     * @return string|null
     */
    public function getSSVCategory()
    {
        return $this->SSVCategory;
    }
    /**
     * Set SSVCategory value
     * @param string $sSVCategory
     * @return \StructType\SpecialServices
     */
    public function setSSVCategory($sSVCategory = null)
    {
        // validation for constraint: string
        if (!is_null($sSVCategory) && !is_string($sSVCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSVCategory)), __LINE__);
        }
        $this->SSVCategory = $sSVCategory;
        return $this;
    }
    /**
     * Get SSVAvlLocation value
     * @return string|null
     */
    public function getSSVAvlLocation()
    {
        return $this->SSVAvlLocation;
    }
    /**
     * Set SSVAvlLocation value
     * @param string $sSVAvlLocation
     * @return \StructType\SpecialServices
     */
    public function setSSVAvlLocation($sSVAvlLocation = null)
    {
        // validation for constraint: string
        if (!is_null($sSVAvlLocation) && !is_string($sSVAvlLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSVAvlLocation)), __LINE__);
        }
        $this->SSVAvlLocation = $sSVAvlLocation;
        return $this;
    }
    /**
     * Get SSVSellable value
     * @return \StructType\SSVSellable|null
     */
    public function getSSVSellable()
    {
        return $this->SSVSellable;
    }
    /**
     * Set SSVSellable value
     * @param \StructType\SSVSellable $sSVSellable
     * @return \StructType\SpecialServices
     */
    public function setSSVSellable(\StructType\SSVSellable $sSVSellable = null)
    {
        $this->SSVSellable = $sSVSellable;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \StructType\SpecialServices
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get PaxId value
     * @return string|null
     */
    public function getPaxId()
    {
        return $this->PaxId;
    }
    /**
     * Set PaxId value
     * @param string $paxId
     * @return \StructType\SpecialServices
     */
    public function setPaxId($paxId = null)
    {
        // validation for constraint: string
        if (!is_null($paxId) && !is_string($paxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paxId)), __LINE__);
        }
        $this->PaxId = $paxId;
        return $this;
    }
    /**
     * Get Delivery value
     * @return string|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param string $delivery
     * @return \StructType\SpecialServices
     */
    public function setDelivery($delivery = null)
    {
        // validation for constraint: string
        if (!is_null($delivery) && !is_string($delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delivery)), __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get GiftText value
     * @return string|null
     */
    public function getGiftText()
    {
        return $this->GiftText;
    }
    /**
     * Set GiftText value
     * @param string $giftText
     * @return \StructType\SpecialServices
     */
    public function setGiftText($giftText = null)
    {
        // validation for constraint: string
        if (!is_null($giftText) && !is_string($giftText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($giftText)), __LINE__);
        }
        $this->GiftText = $giftText;
        return $this;
    }
    /**
     * Get Instruction value
     * @return string|null
     */
    public function getInstruction()
    {
        return $this->Instruction;
    }
    /**
     * Set Instruction value
     * @param string $instruction
     * @return \StructType\SpecialServices
     */
    public function setInstruction($instruction = null)
    {
        // validation for constraint: string
        if (!is_null($instruction) && !is_string($instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instruction)), __LINE__);
        }
        $this->Instruction = $instruction;
        return $this;
    }
    /**
     * Get PortConfirmation value
     * @return string|null
     */
    public function getPortConfirmation()
    {
        return $this->PortConfirmation;
    }
    /**
     * Set PortConfirmation value
     * @param string $portConfirmation
     * @return \StructType\SpecialServices
     */
    public function setPortConfirmation($portConfirmation = null)
    {
        // validation for constraint: string
        if (!is_null($portConfirmation) && !is_string($portConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portConfirmation)), __LINE__);
        }
        $this->PortConfirmation = $portConfirmation;
        return $this;
    }
    /**
     * Get VaucherControl value
     * @return string|null
     */
    public function getVaucherControl()
    {
        return $this->VaucherControl;
    }
    /**
     * Set VaucherControl value
     * @param string $vaucherControl
     * @return \StructType\SpecialServices
     */
    public function setVaucherControl($vaucherControl = null)
    {
        // validation for constraint: string
        if (!is_null($vaucherControl) && !is_string($vaucherControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vaucherControl)), __LINE__);
        }
        $this->VaucherControl = $vaucherControl;
        return $this;
    }
    /**
     * Get SSVCurrency value
     * @return string|null
     */
    public function getSSVCurrency()
    {
        return $this->SSVCurrency;
    }
    /**
     * Set SSVCurrency value
     * @param string $sSVCurrency
     * @return \StructType\SpecialServices
     */
    public function setSSVCurrency($sSVCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($sSVCurrency) && !is_string($sSVCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSVCurrency)), __LINE__);
        }
        $this->SSVCurrency = $sSVCurrency;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\SpecialServices
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get AdultAgeLimits value
     * @return string|null
     */
    public function getAdultAgeLimits()
    {
        return $this->AdultAgeLimits;
    }
    /**
     * Set AdultAgeLimits value
     * @param string $adultAgeLimits
     * @return \StructType\SpecialServices
     */
    public function setAdultAgeLimits($adultAgeLimits = null)
    {
        // validation for constraint: string
        if (!is_null($adultAgeLimits) && !is_string($adultAgeLimits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adultAgeLimits)), __LINE__);
        }
        $this->AdultAgeLimits = $adultAgeLimits;
        return $this;
    }
    /**
     * Get ChildAgeLimits value
     * @return string|null
     */
    public function getChildAgeLimits()
    {
        return $this->ChildAgeLimits;
    }
    /**
     * Set ChildAgeLimits value
     * @param string $childAgeLimits
     * @return \StructType\SpecialServices
     */
    public function setChildAgeLimits($childAgeLimits = null)
    {
        // validation for constraint: string
        if (!is_null($childAgeLimits) && !is_string($childAgeLimits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($childAgeLimits)), __LINE__);
        }
        $this->ChildAgeLimits = $childAgeLimits;
        return $this;
    }
    /**
     * Get SSVAvailable value
     * @return \StructType\SSVAvailable|null
     */
    public function getSSVAvailable()
    {
        return $this->SSVAvailable;
    }
    /**
     * Set SSVAvailable value
     * @param \StructType\SSVAvailable $sSVAvailable
     * @return \StructType\SpecialServices
     */
    public function setSSVAvailable(\StructType\SSVAvailable $sSVAvailable = null)
    {
        $this->SSVAvailable = $sSVAvailable;
        return $this;
    }
    /**
     * Get PrintOnConfLetter value
     * @return \StructType\PrintOnConfLetter|null
     */
    public function getPrintOnConfLetter()
    {
        return $this->PrintOnConfLetter;
    }
    /**
     * Set PrintOnConfLetter value
     * @param \StructType\PrintOnConfLetter $printOnConfLetter
     * @return \StructType\SpecialServices
     */
    public function setPrintOnConfLetter(\StructType\PrintOnConfLetter $printOnConfLetter = null)
    {
        $this->PrintOnConfLetter = $printOnConfLetter;
        return $this;
    }
    /**
     * Get VoucherInfo value
     * @return \StructType\VoucherInfo|null
     */
    public function getVoucherInfo()
    {
        return $this->VoucherInfo;
    }
    /**
     * Set VoucherInfo value
     * @param \StructType\VoucherInfo $voucherInfo
     * @return \StructType\SpecialServices
     */
    public function setVoucherInfo(\StructType\VoucherInfo $voucherInfo = null)
    {
        $this->VoucherInfo = $voucherInfo;
        return $this;
    }
    /**
     * Get IsAuto value
     * @return string|null
     */
    public function getIsAuto()
    {
        return $this->IsAuto;
    }
    /**
     * Set IsAuto value
     * @param string $isAuto
     * @return \StructType\SpecialServices
     */
    public function setIsAuto($isAuto = null)
    {
        // validation for constraint: string
        if (!is_null($isAuto) && !is_string($isAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAuto)), __LINE__);
        }
        $this->IsAuto = $isAuto;
        return $this;
    }
    /**
     * Get GuestSequenceNumber value
     * @return string|null
     */
    public function getGuestSequenceNumber()
    {
        return $this->GuestSequenceNumber;
    }
    /**
     * Set GuestSequenceNumber value
     * @param string $guestSequenceNumber
     * @return \StructType\SpecialServices
     */
    public function setGuestSequenceNumber($guestSequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($guestSequenceNumber) && !is_string($guestSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guestSequenceNumber)), __LINE__);
        }
        $this->GuestSequenceNumber = $guestSequenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
