<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialItem StructType
 * @subpackage Structs
 */
class SpecialItem extends AbstractStructBase
{
    /**
     * The IsAuto
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAuto;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CruiseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseId;
    /**
     * The CabinNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CabinNumber;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * Constructor method for SpecialItem
     * @uses SpecialItem::setIsAuto()
     * @uses SpecialItem::setType()
     * @uses SpecialItem::setDescription()
     * @uses SpecialItem::setCruiseId()
     * @uses SpecialItem::setCabinNumber()
     * @uses SpecialItem::setNote()
     * @param bool $isAuto
     * @param string $type
     * @param string $description
     * @param string $cruiseId
     * @param string $cabinNumber
     * @param string $note
     */
    public function __construct($isAuto = null, $type = null, $description = null, $cruiseId = null, $cabinNumber = null, $note = null)
    {
        $this
            ->setIsAuto($isAuto)
            ->setType($type)
            ->setDescription($description)
            ->setCruiseId($cruiseId)
            ->setCabinNumber($cabinNumber)
            ->setNote($note);
    }
    /**
     * Get IsAuto value
     * @return bool
     */
    public function getIsAuto()
    {
        return $this->IsAuto;
    }
    /**
     * Set IsAuto value
     * @param bool $isAuto
     * @return \StructType\SpecialItem
     */
    public function setIsAuto($isAuto = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuto) && !is_bool($isAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAuto)), __LINE__);
        }
        $this->IsAuto = $isAuto;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SpecialItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SpecialItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CruiseId value
     * @return string|null
     */
    public function getCruiseId()
    {
        return $this->CruiseId;
    }
    /**
     * Set CruiseId value
     * @param string $cruiseId
     * @return \StructType\SpecialItem
     */
    public function setCruiseId($cruiseId = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseId) && !is_string($cruiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseId)), __LINE__);
        }
        $this->CruiseId = $cruiseId;
        return $this;
    }
    /**
     * Get CabinNumber value
     * @return string|null
     */
    public function getCabinNumber()
    {
        return $this->CabinNumber;
    }
    /**
     * Set CabinNumber value
     * @param string $cabinNumber
     * @return \StructType\SpecialItem
     */
    public function setCabinNumber($cabinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cabinNumber) && !is_string($cabinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinNumber)), __LINE__);
        }
        $this->CabinNumber = $cabinNumber;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\SpecialItem
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
