<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ship StructType
 * @subpackage Structs
 */
class Ship extends AbstractStructBase
{
    /**
     * The Cabins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Cabins;
    /**
     * The Crew
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Crew;
    /**
     * The Guests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Guests;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Width;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Length;
    /**
     * The Tonnage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tonnage;
    /**
     * The MaxSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxSpeed;
    /**
     * The YearOfLaunch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $YearOfLaunch;
    /**
     * The MonthOfLaunch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MonthOfLaunch;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The LongDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongDescription;
    /**
     * The EBdescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EBdescription;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The Categories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCategory
     */
    public $Categories;
    /**
     * The PublicAreas
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPublicArea
     */
    public $PublicAreas;
    /**
     * The AlternativeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlternativeDescription;
    /**
     * Constructor method for Ship
     * @uses Ship::setCabins()
     * @uses Ship::setCrew()
     * @uses Ship::setGuests()
     * @uses Ship::setWidth()
     * @uses Ship::setLength()
     * @uses Ship::setTonnage()
     * @uses Ship::setMaxSpeed()
     * @uses Ship::setYearOfLaunch()
     * @uses Ship::setMonthOfLaunch()
     * @uses Ship::setCode()
     * @uses Ship::setName()
     * @uses Ship::setURL()
     * @uses Ship::setAdditionalInfo()
     * @uses Ship::setDescription()
     * @uses Ship::setLongDescription()
     * @uses Ship::setEBdescription()
     * @uses Ship::setInfo()
     * @uses Ship::setCategories()
     * @uses Ship::setPublicAreas()
     * @uses Ship::setAlternativeDescription()
     * @param int $cabins
     * @param int $crew
     * @param int $guests
     * @param float $width
     * @param float $length
     * @param float $tonnage
     * @param float $maxSpeed
     * @param int $yearOfLaunch
     * @param int $monthOfLaunch
     * @param string $code
     * @param string $name
     * @param string $uRL
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param string $description
     * @param string $longDescription
     * @param string $eBdescription
     * @param string $info
     * @param \ArrayType\ArrayOfCategory $categories
     * @param \ArrayType\ArrayOfPublicArea $publicAreas
     * @param string $alternativeDescription
     */
    public function __construct($cabins = null, $crew = null, $guests = null, $width = null, $length = null, $tonnage = null, $maxSpeed = null, $yearOfLaunch = null, $monthOfLaunch = null, $code = null, $name = null, $uRL = null, \StructType\AdditionaInfo $additionalInfo = null, $description = null, $longDescription = null, $eBdescription = null, $info = null, \ArrayType\ArrayOfCategory $categories = null, \ArrayType\ArrayOfPublicArea $publicAreas = null, $alternativeDescription = null)
    {
        $this
            ->setCabins($cabins)
            ->setCrew($crew)
            ->setGuests($guests)
            ->setWidth($width)
            ->setLength($length)
            ->setTonnage($tonnage)
            ->setMaxSpeed($maxSpeed)
            ->setYearOfLaunch($yearOfLaunch)
            ->setMonthOfLaunch($monthOfLaunch)
            ->setCode($code)
            ->setName($name)
            ->setURL($uRL)
            ->setAdditionalInfo($additionalInfo)
            ->setDescription($description)
            ->setLongDescription($longDescription)
            ->setEBdescription($eBdescription)
            ->setInfo($info)
            ->setCategories($categories)
            ->setPublicAreas($publicAreas)
            ->setAlternativeDescription($alternativeDescription);
    }
    /**
     * Get Cabins value
     * @return int
     */
    public function getCabins()
    {
        return $this->Cabins;
    }
    /**
     * Set Cabins value
     * @param int $cabins
     * @return \StructType\Ship
     */
    public function setCabins($cabins = null)
    {
        // validation for constraint: int
        if (!is_null($cabins) && !is_numeric($cabins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cabins)), __LINE__);
        }
        $this->Cabins = $cabins;
        return $this;
    }
    /**
     * Get Crew value
     * @return int
     */
    public function getCrew()
    {
        return $this->Crew;
    }
    /**
     * Set Crew value
     * @param int $crew
     * @return \StructType\Ship
     */
    public function setCrew($crew = null)
    {
        // validation for constraint: int
        if (!is_null($crew) && !is_numeric($crew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($crew)), __LINE__);
        }
        $this->Crew = $crew;
        return $this;
    }
    /**
     * Get Guests value
     * @return int
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param int $guests
     * @return \StructType\Ship
     */
    public function setGuests($guests = null)
    {
        // validation for constraint: int
        if (!is_null($guests) && !is_numeric($guests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($guests)), __LINE__);
        }
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get Width value
     * @return float
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\Ship
     */
    public function setWidth($width = null)
    {
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Length value
     * @return float
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\Ship
     */
    public function setLength($length = null)
    {
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Tonnage value
     * @return float
     */
    public function getTonnage()
    {
        return $this->Tonnage;
    }
    /**
     * Set Tonnage value
     * @param float $tonnage
     * @return \StructType\Ship
     */
    public function setTonnage($tonnage = null)
    {
        $this->Tonnage = $tonnage;
        return $this;
    }
    /**
     * Get MaxSpeed value
     * @return float
     */
    public function getMaxSpeed()
    {
        return $this->MaxSpeed;
    }
    /**
     * Set MaxSpeed value
     * @param float $maxSpeed
     * @return \StructType\Ship
     */
    public function setMaxSpeed($maxSpeed = null)
    {
        $this->MaxSpeed = $maxSpeed;
        return $this;
    }
    /**
     * Get YearOfLaunch value
     * @return int
     */
    public function getYearOfLaunch()
    {
        return $this->YearOfLaunch;
    }
    /**
     * Set YearOfLaunch value
     * @param int $yearOfLaunch
     * @return \StructType\Ship
     */
    public function setYearOfLaunch($yearOfLaunch = null)
    {
        // validation for constraint: int
        if (!is_null($yearOfLaunch) && !is_numeric($yearOfLaunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($yearOfLaunch)), __LINE__);
        }
        $this->YearOfLaunch = $yearOfLaunch;
        return $this;
    }
    /**
     * Get MonthOfLaunch value
     * @return int
     */
    public function getMonthOfLaunch()
    {
        return $this->MonthOfLaunch;
    }
    /**
     * Set MonthOfLaunch value
     * @param int $monthOfLaunch
     * @return \StructType\Ship
     */
    public function setMonthOfLaunch($monthOfLaunch = null)
    {
        // validation for constraint: int
        if (!is_null($monthOfLaunch) && !is_numeric($monthOfLaunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($monthOfLaunch)), __LINE__);
        }
        $this->MonthOfLaunch = $monthOfLaunch;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Ship
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Ship
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Ship
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Ship
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Ship
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \StructType\Ship
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get EBdescription value
     * @return string|null
     */
    public function getEBdescription()
    {
        return $this->EBdescription;
    }
    /**
     * Set EBdescription value
     * @param string $eBdescription
     * @return \StructType\Ship
     */
    public function setEBdescription($eBdescription = null)
    {
        // validation for constraint: string
        if (!is_null($eBdescription) && !is_string($eBdescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eBdescription)), __LINE__);
        }
        $this->EBdescription = $eBdescription;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\Ship
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get Categories value
     * @return \ArrayType\ArrayOfCategory|null
     */
    public function getCategories()
    {
        return $this->Categories;
    }
    /**
     * Set Categories value
     * @param \ArrayType\ArrayOfCategory $categories
     * @return \StructType\Ship
     */
    public function setCategories(\ArrayType\ArrayOfCategory $categories = null)
    {
        $this->Categories = $categories;
        return $this;
    }
    /**
     * Get PublicAreas value
     * @return \ArrayType\ArrayOfPublicArea|null
     */
    public function getPublicAreas()
    {
        return $this->PublicAreas;
    }
    /**
     * Set PublicAreas value
     * @param \ArrayType\ArrayOfPublicArea $publicAreas
     * @return \StructType\Ship
     */
    public function setPublicAreas(\ArrayType\ArrayOfPublicArea $publicAreas = null)
    {
        $this->PublicAreas = $publicAreas;
        return $this;
    }
    /**
     * Get AlternativeDescription value
     * @return string|null
     */
    public function getAlternativeDescription()
    {
        return $this->AlternativeDescription;
    }
    /**
     * Set AlternativeDescription value
     * @param string $alternativeDescription
     * @return \StructType\Ship
     */
    public function setAlternativeDescription($alternativeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeDescription) && !is_string($alternativeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativeDescription)), __LINE__);
        }
        $this->AlternativeDescription = $alternativeDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
