<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSVRules StructType
 * @subpackage Structs
 */
class SSVRules extends AbstractStructBase
{
    /**
     * The DateRequiredInd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DateRequiredInd;
    /**
     * The YearsRequiredInd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $YearsRequiredInd;
    /**
     * The MinimumGuests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinimumGuests;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for SSVRules
     * @uses SSVRules::setDateRequiredInd()
     * @uses SSVRules::setYearsRequiredInd()
     * @uses SSVRules::setMinimumGuests()
     * @uses SSVRules::setBeginDate()
     * @uses SSVRules::setEndDate()
     * @param bool $dateRequiredInd
     * @param bool $yearsRequiredInd
     * @param int $minimumGuests
     * @param string $beginDate
     * @param string $endDate
     */
    public function __construct($dateRequiredInd = null, $yearsRequiredInd = null, $minimumGuests = null, $beginDate = null, $endDate = null)
    {
        $this
            ->setDateRequiredInd($dateRequiredInd)
            ->setYearsRequiredInd($yearsRequiredInd)
            ->setMinimumGuests($minimumGuests)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate);
    }
    /**
     * Get DateRequiredInd value
     * @return bool
     */
    public function getDateRequiredInd()
    {
        return $this->DateRequiredInd;
    }
    /**
     * Set DateRequiredInd value
     * @param bool $dateRequiredInd
     * @return \StructType\SSVRules
     */
    public function setDateRequiredInd($dateRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($dateRequiredInd) && !is_bool($dateRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dateRequiredInd)), __LINE__);
        }
        $this->DateRequiredInd = $dateRequiredInd;
        return $this;
    }
    /**
     * Get YearsRequiredInd value
     * @return bool
     */
    public function getYearsRequiredInd()
    {
        return $this->YearsRequiredInd;
    }
    /**
     * Set YearsRequiredInd value
     * @param bool $yearsRequiredInd
     * @return \StructType\SSVRules
     */
    public function setYearsRequiredInd($yearsRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($yearsRequiredInd) && !is_bool($yearsRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($yearsRequiredInd)), __LINE__);
        }
        $this->YearsRequiredInd = $yearsRequiredInd;
        return $this;
    }
    /**
     * Get MinimumGuests value
     * @return int
     */
    public function getMinimumGuests()
    {
        return $this->MinimumGuests;
    }
    /**
     * Set MinimumGuests value
     * @param int $minimumGuests
     * @return \StructType\SSVRules
     */
    public function setMinimumGuests($minimumGuests = null)
    {
        // validation for constraint: int
        if (!is_null($minimumGuests) && !is_numeric($minimumGuests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumGuests)), __LINE__);
        }
        $this->MinimumGuests = $minimumGuests;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\SSVRules
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\SSVRules
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSVRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
