<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomType StructType
 * @subpackage Structs
 */
class RoomType extends AbstractStructBase
{
    /**
     * The NumberOfBeds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfBeds;
    /**
     * The RoomPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomPrice
     */
    public $RoomPrices;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * Constructor method for RoomType
     * @uses RoomType::setNumberOfBeds()
     * @uses RoomType::setRoomPrices()
     * @uses RoomType::setCategory()
     * @param int $numberOfBeds
     * @param \ArrayType\ArrayOfRoomPrice $roomPrices
     * @param string $category
     */
    public function __construct($numberOfBeds = null, \ArrayType\ArrayOfRoomPrice $roomPrices = null, $category = null)
    {
        $this
            ->setNumberOfBeds($numberOfBeds)
            ->setRoomPrices($roomPrices)
            ->setCategory($category);
    }
    /**
     * Get NumberOfBeds value
     * @return int
     */
    public function getNumberOfBeds()
    {
        return $this->NumberOfBeds;
    }
    /**
     * Set NumberOfBeds value
     * @param int $numberOfBeds
     * @return \StructType\RoomType
     */
    public function setNumberOfBeds($numberOfBeds = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBeds) && !is_numeric($numberOfBeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBeds)), __LINE__);
        }
        $this->NumberOfBeds = $numberOfBeds;
        return $this;
    }
    /**
     * Get RoomPrices value
     * @return \ArrayType\ArrayOfRoomPrice|null
     */
    public function getRoomPrices()
    {
        return $this->RoomPrices;
    }
    /**
     * Set RoomPrices value
     * @param \ArrayType\ArrayOfRoomPrice $roomPrices
     * @return \StructType\RoomType
     */
    public function setRoomPrices(\ArrayType\ArrayOfRoomPrice $roomPrices = null)
    {
        $this->RoomPrices = $roomPrices;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\RoomType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
