<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromoFlights StructType
 * @subpackage Structs
 */
class PromoFlights extends AbstractStructBase
{
    /**
     * The AvailablePromoFlights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AvailablePromoFlights;
    /**
     * The PromoFlightsFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PromoFlightsFees;
    /**
     * The OnlyPromoFlight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OnlyPromoFlight;
    /**
     * The FlightClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightClass;
    /**
     * Constructor method for PromoFlights
     * @uses PromoFlights::setAvailablePromoFlights()
     * @uses PromoFlights::setPromoFlightsFees()
     * @uses PromoFlights::setOnlyPromoFlight()
     * @uses PromoFlights::setFlightClass()
     * @param bool $availablePromoFlights
     * @param bool $promoFlightsFees
     * @param bool $onlyPromoFlight
     * @param string $flightClass
     */
    public function __construct($availablePromoFlights = null, $promoFlightsFees = null, $onlyPromoFlight = null, $flightClass = null)
    {
        $this
            ->setAvailablePromoFlights($availablePromoFlights)
            ->setPromoFlightsFees($promoFlightsFees)
            ->setOnlyPromoFlight($onlyPromoFlight)
            ->setFlightClass($flightClass);
    }
    /**
     * Get AvailablePromoFlights value
     * @return bool
     */
    public function getAvailablePromoFlights()
    {
        return $this->AvailablePromoFlights;
    }
    /**
     * Set AvailablePromoFlights value
     * @param bool $availablePromoFlights
     * @return \StructType\PromoFlights
     */
    public function setAvailablePromoFlights($availablePromoFlights = null)
    {
        // validation for constraint: boolean
        if (!is_null($availablePromoFlights) && !is_bool($availablePromoFlights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availablePromoFlights)), __LINE__);
        }
        $this->AvailablePromoFlights = $availablePromoFlights;
        return $this;
    }
    /**
     * Get PromoFlightsFees value
     * @return bool
     */
    public function getPromoFlightsFees()
    {
        return $this->PromoFlightsFees;
    }
    /**
     * Set PromoFlightsFees value
     * @param bool $promoFlightsFees
     * @return \StructType\PromoFlights
     */
    public function setPromoFlightsFees($promoFlightsFees = null)
    {
        // validation for constraint: boolean
        if (!is_null($promoFlightsFees) && !is_bool($promoFlightsFees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($promoFlightsFees)), __LINE__);
        }
        $this->PromoFlightsFees = $promoFlightsFees;
        return $this;
    }
    /**
     * Get OnlyPromoFlight value
     * @return bool
     */
    public function getOnlyPromoFlight()
    {
        return $this->OnlyPromoFlight;
    }
    /**
     * Set OnlyPromoFlight value
     * @param bool $onlyPromoFlight
     * @return \StructType\PromoFlights
     */
    public function setOnlyPromoFlight($onlyPromoFlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyPromoFlight) && !is_bool($onlyPromoFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlyPromoFlight)), __LINE__);
        }
        $this->OnlyPromoFlight = $onlyPromoFlight;
        return $this;
    }
    /**
     * Get FlightClass value
     * @return string|null
     */
    public function getFlightClass()
    {
        return $this->FlightClass;
    }
    /**
     * Set FlightClass value
     * @param string $flightClass
     * @return \StructType\PromoFlights
     */
    public function setFlightClass($flightClass = null)
    {
        // validation for constraint: string
        if (!is_null($flightClass) && !is_string($flightClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightClass)), __LINE__);
        }
        $this->FlightClass = $flightClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PromoFlights
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
