<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerLoyalty StructType
 * @subpackage Structs
 */
class PartnerLoyalty extends AbstractStructBase
{
    /**
     * The ProgramCd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramCd;
    /**
     * The MembershipId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MembershipId;
    /**
     * Constructor method for PartnerLoyalty
     * @uses PartnerLoyalty::setProgramCd()
     * @uses PartnerLoyalty::setMembershipId()
     * @param string $programCd
     * @param string $membershipId
     */
    public function __construct($programCd = null, $membershipId = null)
    {
        $this
            ->setProgramCd($programCd)
            ->setMembershipId($membershipId);
    }
    /**
     * Get ProgramCd value
     * @return string|null
     */
    public function getProgramCd()
    {
        return $this->ProgramCd;
    }
    /**
     * Set ProgramCd value
     * @param string $programCd
     * @return \StructType\PartnerLoyalty
     */
    public function setProgramCd($programCd = null)
    {
        // validation for constraint: string
        if (!is_null($programCd) && !is_string($programCd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programCd)), __LINE__);
        }
        $this->ProgramCd = $programCd;
        return $this;
    }
    /**
     * Get MembershipId value
     * @return string|null
     */
    public function getMembershipId()
    {
        return $this->MembershipId;
    }
    /**
     * Set MembershipId value
     * @param string $membershipId
     * @return \StructType\PartnerLoyalty
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($membershipId)), __LINE__);
        }
        $this->MembershipId = $membershipId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
