<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiCruiseInsurance StructType
 * @subpackage Structs
 */
class MultiCruiseInsurance extends AbstractStructBase
{
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Insurance;
    /**
     * The InsuranceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceType;
    /**
     * Constructor method for MultiCruiseInsurance
     * @uses MultiCruiseInsurance::setInsurance()
     * @uses MultiCruiseInsurance::setInsuranceType()
     * @param bool $insurance
     * @param string $insuranceType
     */
    public function __construct($insurance = null, $insuranceType = null)
    {
        $this
            ->setInsurance($insurance)
            ->setInsuranceType($insuranceType);
    }
    /**
     * Get Insurance value
     * @return bool
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param bool $insurance
     * @return \StructType\MultiCruiseInsurance
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($insurance) && !is_bool($insurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($insurance)), __LINE__);
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get InsuranceType value
     * @return string|null
     */
    public function getInsuranceType()
    {
        return $this->InsuranceType;
    }
    /**
     * Set InsuranceType value
     * @param string $insuranceType
     * @return \StructType\MultiCruiseInsurance
     */
    public function setInsuranceType($insuranceType = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceType) && !is_string($insuranceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceType)), __LINE__);
        }
        $this->InsuranceType = $insuranceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultiCruiseInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
