<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListPorts StructType
 * @subpackage Structs
 */
class ListPorts extends AbstractStructBase
{
    /**
     * The destinationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationCode;
    /**
     * The shipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipCode;
    /**
     * Constructor method for ListPorts
     * @uses ListPorts::setDestinationCode()
     * @uses ListPorts::setShipCode()
     * @param string $destinationCode
     * @param string $shipCode
     */
    public function __construct($destinationCode = null, $shipCode = null)
    {
        $this
            ->setDestinationCode($destinationCode)
            ->setShipCode($shipCode);
    }
    /**
     * Get destinationCode value
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->destinationCode;
    }
    /**
     * Set destinationCode value
     * @param string $destinationCode
     * @return \StructType\ListPorts
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationCode)), __LINE__);
        }
        $this->destinationCode = $destinationCode;
        return $this;
    }
    /**
     * Get shipCode value
     * @return string|null
     */
    public function getShipCode()
    {
        return $this->shipCode;
    }
    /**
     * Set shipCode value
     * @param string $shipCode
     * @return \StructType\ListPorts
     */
    public function setShipCode($shipCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipCode) && !is_string($shipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipCode)), __LINE__);
        }
        $this->shipCode = $shipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListPorts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
