<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary StructType
 * @subpackage Structs
 */
class Itinerary extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Segments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSegment
     */
    public $Segments;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The AirRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirRemarks;
    /**
     * The CruiseRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseRemarks;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setCode()
     * @uses Itinerary::setURL()
     * @uses Itinerary::setSegments()
     * @uses Itinerary::setAdditionalInfo()
     * @uses Itinerary::setAirRemarks()
     * @uses Itinerary::setCruiseRemarks()
     * @param string $code
     * @param string $uRL
     * @param \ArrayType\ArrayOfSegment $segments
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param string $airRemarks
     * @param string $cruiseRemarks
     */
    public function __construct($code = null, $uRL = null, \ArrayType\ArrayOfSegment $segments = null, \StructType\AdditionaInfo $additionalInfo = null, $airRemarks = null, $cruiseRemarks = null)
    {
        $this
            ->setCode($code)
            ->setURL($uRL)
            ->setSegments($segments)
            ->setAdditionalInfo($additionalInfo)
            ->setAirRemarks($airRemarks)
            ->setCruiseRemarks($cruiseRemarks);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Itinerary
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Itinerary
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Segments value
     * @return \ArrayType\ArrayOfSegment|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @param \ArrayType\ArrayOfSegment $segments
     * @return \StructType\Itinerary
     */
    public function setSegments(\ArrayType\ArrayOfSegment $segments = null)
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Itinerary
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get AirRemarks value
     * @return string|null
     */
    public function getAirRemarks()
    {
        return $this->AirRemarks;
    }
    /**
     * Set AirRemarks value
     * @param string $airRemarks
     * @return \StructType\Itinerary
     */
    public function setAirRemarks($airRemarks = null)
    {
        // validation for constraint: string
        if (!is_null($airRemarks) && !is_string($airRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airRemarks)), __LINE__);
        }
        $this->AirRemarks = $airRemarks;
        return $this;
    }
    /**
     * Get CruiseRemarks value
     * @return string|null
     */
    public function getCruiseRemarks()
    {
        return $this->CruiseRemarks;
    }
    /**
     * Set CruiseRemarks value
     * @param string $cruiseRemarks
     * @return \StructType\Itinerary
     */
    public function setCruiseRemarks($cruiseRemarks = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseRemarks) && !is_string($cruiseRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseRemarks)), __LINE__);
        }
        $this->CruiseRemarks = $cruiseRemarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Itinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
