<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel StructType
 * @subpackage Structs
 */
class Hotel extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The RoomTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomType
     */
    public $RoomTypes;
    /**
     * The LongDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongDescription;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for Hotel
     * @uses Hotel::setCode()
     * @uses Hotel::setDescription()
     * @uses Hotel::setRoomTypes()
     * @uses Hotel::setLongDescription()
     * @uses Hotel::setCurrencyCode()
     * @param string $code
     * @param string $description
     * @param \ArrayType\ArrayOfRoomType $roomTypes
     * @param string $longDescription
     * @param string $currencyCode
     */
    public function __construct($code = null, $description = null, \ArrayType\ArrayOfRoomType $roomTypes = null, $longDescription = null, $currencyCode = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setRoomTypes($roomTypes)
            ->setLongDescription($longDescription)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Hotel
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Hotel
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RoomTypes value
     * @return \ArrayType\ArrayOfRoomType|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \ArrayType\ArrayOfRoomType $roomTypes
     * @return \StructType\Hotel
     */
    public function setRoomTypes(\ArrayType\ArrayOfRoomType $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \StructType\Hotel
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\Hotel
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Hotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
