<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestDocument StructType
 * @subpackage Structs
 */
class GuestDocument extends AbstractStructBase
{
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpirationDate;
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssueDate;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The IssuedInCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuedInCountry;
    /**
     * The IssuedInCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuedInCity;
    /**
     * Constructor method for GuestDocument
     * @uses GuestDocument::setExpirationDate()
     * @uses GuestDocument::setIssueDate()
     * @uses GuestDocument::setType()
     * @uses GuestDocument::setNumber()
     * @uses GuestDocument::setIssuedInCountry()
     * @uses GuestDocument::setIssuedInCity()
     * @param string $expirationDate
     * @param string $issueDate
     * @param string $type
     * @param string $number
     * @param string $issuedInCountry
     * @param string $issuedInCity
     */
    public function __construct($expirationDate = null, $issueDate = null, $type = null, $number = null, $issuedInCountry = null, $issuedInCity = null)
    {
        $this
            ->setExpirationDate($expirationDate)
            ->setIssueDate($issueDate)
            ->setType($type)
            ->setNumber($number)
            ->setIssuedInCountry($issuedInCountry)
            ->setIssuedInCity($issuedInCity);
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\GuestDocument
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\GuestDocument
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\GuestDocument
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\GuestDocument
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get IssuedInCountry value
     * @return string|null
     */
    public function getIssuedInCountry()
    {
        return $this->IssuedInCountry;
    }
    /**
     * Set IssuedInCountry value
     * @param string $issuedInCountry
     * @return \StructType\GuestDocument
     */
    public function setIssuedInCountry($issuedInCountry = null)
    {
        // validation for constraint: string
        if (!is_null($issuedInCountry) && !is_string($issuedInCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuedInCountry)), __LINE__);
        }
        $this->IssuedInCountry = $issuedInCountry;
        return $this;
    }
    /**
     * Get IssuedInCity value
     * @return string|null
     */
    public function getIssuedInCity()
    {
        return $this->IssuedInCity;
    }
    /**
     * Set IssuedInCity value
     * @param string $issuedInCity
     * @return \StructType\GuestDocument
     */
    public function setIssuedInCity($issuedInCity = null)
    {
        // validation for constraint: string
        if (!is_null($issuedInCity) && !is_string($issuedInCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuedInCity)), __LINE__);
        }
        $this->IssuedInCity = $issuedInCity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
