<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestCabinInfo StructType
 * @subpackage Structs
 */
class GuestCabinInfo extends AbstractStructBase
{
    /**
     * The CabinNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CabinNumber;
    /**
     * The CategoryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryCode;
    /**
     * The CruiseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseCode;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The ServiceLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceLevel;
    /**
     * Constructor method for GuestCabinInfo
     * @uses GuestCabinInfo::setCabinNumber()
     * @uses GuestCabinInfo::setCategoryCode()
     * @uses GuestCabinInfo::setCruiseCode()
     * @uses GuestCabinInfo::setFirstName()
     * @uses GuestCabinInfo::setLastName()
     * @uses GuestCabinInfo::setServiceLevel()
     * @param string $cabinNumber
     * @param string $categoryCode
     * @param string $cruiseCode
     * @param string $firstName
     * @param string $lastName
     * @param string $serviceLevel
     */
    public function __construct($cabinNumber = null, $categoryCode = null, $cruiseCode = null, $firstName = null, $lastName = null, $serviceLevel = null)
    {
        $this
            ->setCabinNumber($cabinNumber)
            ->setCategoryCode($categoryCode)
            ->setCruiseCode($cruiseCode)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setServiceLevel($serviceLevel);
    }
    /**
     * Get CabinNumber value
     * @return string|null
     */
    public function getCabinNumber()
    {
        return $this->CabinNumber;
    }
    /**
     * Set CabinNumber value
     * @param string $cabinNumber
     * @return \StructType\GuestCabinInfo
     */
    public function setCabinNumber($cabinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cabinNumber) && !is_string($cabinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinNumber)), __LINE__);
        }
        $this->CabinNumber = $cabinNumber;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\GuestCabinInfo
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\GuestCabinInfo
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\GuestCabinInfo
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\GuestCabinInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get ServiceLevel value
     * @return string|null
     */
    public function getServiceLevel()
    {
        return $this->ServiceLevel;
    }
    /**
     * Set ServiceLevel value
     * @param string $serviceLevel
     * @return \StructType\GuestCabinInfo
     */
    public function setServiceLevel($serviceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($serviceLevel) && !is_string($serviceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceLevel)), __LINE__);
        }
        $this->ServiceLevel = $serviceLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestCabinInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
