<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest StructType
 * @subpackage Structs
 */
class Guest extends AbstractStructBase
{
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BirthDate;
    /**
     * The GuestType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GuestType;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The LocalizedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalizedName;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nationality;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The PlaceOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfBirth;
    /**
     * The BirthCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthCountry;
    /**
     * The LanguageCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageCode;
    /**
     * The Residence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestResidence
     */
    public $Residence;
    /**
     * The CostaClubNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostaClubNumber;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestDocument
     */
    public $Document;
    /**
     * The RevisionControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestRevisionControl
     */
    public $RevisionControl;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactPhone
     */
    public $Phone;
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuestDocument
     */
    public $Documents;
    /**
     * The MCHotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMCHotel
     */
    public $MCHotel;
    /**
     * The MCTransportation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMCTransportation
     */
    public $MCTransportation;
    /**
     * The TTGSequence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TTGSequence;
    /**
     * The CabinInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuestCabinInfo
     */
    public $CabinInfo;
    /**
     * The MultiCruiseInsurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultiCruiseInsurance
     */
    public $MultiCruiseInsurance;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The ActionCodeTTG
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionCodeTTG;
    /**
     * The SpecialServices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecialServices
     */
    public $SpecialServices;
    /**
     * The ExtendedProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtendedProperties
     */
    public $ExtendedProperties;
    /**
     * The AgeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgeAmount;
    /**
     * The PaxId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxId;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The WebCheckIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WebCheckIn
     */
    public $WebCheckIn;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The SpecialItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecialItem
     */
    public $SpecialItems;
    /**
     * The PrivacyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrivacyInfo
     */
    public $PrivacyInfo;
    /**
     * The Compensations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCompensation
     */
    public $Compensations;
    /**
     * The Privacy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Privacy
     */
    public $Privacy;
    /**
     * The PartnerLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PartnerLoyalty
     */
    public $PartnerLoyalty;
    /**
     * The TravelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TravelInfo
     */
    public $TravelInfo;
    /**
     * The FiscalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FiscalCode;
    /**
     * Constructor method for Guest
     * @uses Guest::setGender()
     * @uses Guest::setBirthDate()
     * @uses Guest::setGuestType()
     * @uses Guest::setFirstName()
     * @uses Guest::setLastName()
     * @uses Guest::setLocalizedName()
     * @uses Guest::setNationality()
     * @uses Guest::setTitle()
     * @uses Guest::setPlaceOfBirth()
     * @uses Guest::setBirthCountry()
     * @uses Guest::setLanguageCode()
     * @uses Guest::setResidence()
     * @uses Guest::setCostaClubNumber()
     * @uses Guest::setDocument()
     * @uses Guest::setRevisionControl()
     * @uses Guest::setAdditionalInfo()
     * @uses Guest::setPhone()
     * @uses Guest::setDocuments()
     * @uses Guest::setMCHotel()
     * @uses Guest::setMCTransportation()
     * @uses Guest::setTTGSequence()
     * @uses Guest::setCabinInfo()
     * @uses Guest::setMultiCruiseInsurance()
     * @uses Guest::setOrigin()
     * @uses Guest::setActionCodeTTG()
     * @uses Guest::setSpecialServices()
     * @uses Guest::setExtendedProperties()
     * @uses Guest::setAgeAmount()
     * @uses Guest::setPaxId()
     * @uses Guest::setEmail()
     * @uses Guest::setWebCheckIn()
     * @uses Guest::setMobilePhone()
     * @uses Guest::setSpecialItems()
     * @uses Guest::setPrivacyInfo()
     * @uses Guest::setCompensations()
     * @uses Guest::setPrivacy()
     * @uses Guest::setPartnerLoyalty()
     * @uses Guest::setTravelInfo()
     * @uses Guest::setFiscalCode()
     * @param string $gender
     * @param string $birthDate
     * @param string $guestType
     * @param string $firstName
     * @param string $lastName
     * @param string $localizedName
     * @param string $nationality
     * @param string $title
     * @param string $placeOfBirth
     * @param string $birthCountry
     * @param string $languageCode
     * @param \StructType\GuestResidence $residence
     * @param string $costaClubNumber
     * @param \StructType\GuestDocument $document
     * @param \StructType\GuestRevisionControl $revisionControl
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param \StructType\ContactPhone $phone
     * @param \ArrayType\ArrayOfGuestDocument $documents
     * @param \ArrayType\ArrayOfMCHotel $mCHotel
     * @param \ArrayType\ArrayOfMCTransportation $mCTransportation
     * @param string $tTGSequence
     * @param \ArrayType\ArrayOfGuestCabinInfo $cabinInfo
     * @param \StructType\MultiCruiseInsurance $multiCruiseInsurance
     * @param string $origin
     * @param string $actionCodeTTG
     * @param \ArrayType\ArrayOfSpecialServices $specialServices
     * @param \StructType\ExtendedProperties $extendedProperties
     * @param string $ageAmount
     * @param string $paxId
     * @param string $email
     * @param \StructType\WebCheckIn $webCheckIn
     * @param string $mobilePhone
     * @param \ArrayType\ArrayOfSpecialItem $specialItems
     * @param \StructType\PrivacyInfo $privacyInfo
     * @param \ArrayType\ArrayOfCompensation $compensations
     * @param \StructType\Privacy $privacy
     * @param \StructType\PartnerLoyalty $partnerLoyalty
     * @param \StructType\TravelInfo $travelInfo
     * @param string $fiscalCode
     */
    public function __construct($gender = null, $birthDate = null, $guestType = null, $firstName = null, $lastName = null, $localizedName = null, $nationality = null, $title = null, $placeOfBirth = null, $birthCountry = null, $languageCode = null, \StructType\GuestResidence $residence = null, $costaClubNumber = null, \StructType\GuestDocument $document = null, \StructType\GuestRevisionControl $revisionControl = null, \StructType\AdditionaInfo $additionalInfo = null, \StructType\ContactPhone $phone = null, \ArrayType\ArrayOfGuestDocument $documents = null, \ArrayType\ArrayOfMCHotel $mCHotel = null, \ArrayType\ArrayOfMCTransportation $mCTransportation = null, $tTGSequence = null, \ArrayType\ArrayOfGuestCabinInfo $cabinInfo = null, \StructType\MultiCruiseInsurance $multiCruiseInsurance = null, $origin = null, $actionCodeTTG = null, \ArrayType\ArrayOfSpecialServices $specialServices = null, \StructType\ExtendedProperties $extendedProperties = null, $ageAmount = null, $paxId = null, $email = null, \StructType\WebCheckIn $webCheckIn = null, $mobilePhone = null, \ArrayType\ArrayOfSpecialItem $specialItems = null, \StructType\PrivacyInfo $privacyInfo = null, \ArrayType\ArrayOfCompensation $compensations = null, \StructType\Privacy $privacy = null, \StructType\PartnerLoyalty $partnerLoyalty = null, \StructType\TravelInfo $travelInfo = null, $fiscalCode = null)
    {
        $this
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setGuestType($guestType)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setLocalizedName($localizedName)
            ->setNationality($nationality)
            ->setTitle($title)
            ->setPlaceOfBirth($placeOfBirth)
            ->setBirthCountry($birthCountry)
            ->setLanguageCode($languageCode)
            ->setResidence($residence)
            ->setCostaClubNumber($costaClubNumber)
            ->setDocument($document)
            ->setRevisionControl($revisionControl)
            ->setAdditionalInfo($additionalInfo)
            ->setPhone($phone)
            ->setDocuments($documents)
            ->setMCHotel($mCHotel)
            ->setMCTransportation($mCTransportation)
            ->setTTGSequence($tTGSequence)
            ->setCabinInfo($cabinInfo)
            ->setMultiCruiseInsurance($multiCruiseInsurance)
            ->setOrigin($origin)
            ->setActionCodeTTG($actionCodeTTG)
            ->setSpecialServices($specialServices)
            ->setExtendedProperties($extendedProperties)
            ->setAgeAmount($ageAmount)
            ->setPaxId($paxId)
            ->setEmail($email)
            ->setWebCheckIn($webCheckIn)
            ->setMobilePhone($mobilePhone)
            ->setSpecialItems($specialItems)
            ->setPrivacyInfo($privacyInfo)
            ->setCompensations($compensations)
            ->setPrivacy($privacy)
            ->setPartnerLoyalty($partnerLoyalty)
            ->setTravelInfo($travelInfo)
            ->setFiscalCode($fiscalCode);
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Gender::valueIsValid()
     * @uses \EnumType\Gender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\Guest
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Gender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\Guest
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get GuestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->GuestType;
    }
    /**
     * Set GuestType value
     * @uses \EnumType\GuestType::valueIsValid()
     * @uses \EnumType\GuestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guestType
     * @return \StructType\Guest
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuestType::valueIsValid($guestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guestType, implode(', ', \EnumType\GuestType::getValidValues())), __LINE__);
        }
        $this->GuestType = $guestType;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Guest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Guest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get LocalizedName value
     * @return string|null
     */
    public function getLocalizedName()
    {
        return $this->LocalizedName;
    }
    /**
     * Set LocalizedName value
     * @param string $localizedName
     * @return \StructType\Guest
     */
    public function setLocalizedName($localizedName = null)
    {
        // validation for constraint: string
        if (!is_null($localizedName) && !is_string($localizedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizedName)), __LINE__);
        }
        $this->LocalizedName = $localizedName;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\Guest
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Guest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get PlaceOfBirth value
     * @return string|null
     */
    public function getPlaceOfBirth()
    {
        return $this->PlaceOfBirth;
    }
    /**
     * Set PlaceOfBirth value
     * @param string $placeOfBirth
     * @return \StructType\Guest
     */
    public function setPlaceOfBirth($placeOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfBirth) && !is_string($placeOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeOfBirth)), __LINE__);
        }
        $this->PlaceOfBirth = $placeOfBirth;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \StructType\Guest
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\Guest
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get Residence value
     * @return \StructType\GuestResidence|null
     */
    public function getResidence()
    {
        return $this->Residence;
    }
    /**
     * Set Residence value
     * @param \StructType\GuestResidence $residence
     * @return \StructType\Guest
     */
    public function setResidence(\StructType\GuestResidence $residence = null)
    {
        $this->Residence = $residence;
        return $this;
    }
    /**
     * Get CostaClubNumber value
     * @return string|null
     */
    public function getCostaClubNumber()
    {
        return $this->CostaClubNumber;
    }
    /**
     * Set CostaClubNumber value
     * @param string $costaClubNumber
     * @return \StructType\Guest
     */
    public function setCostaClubNumber($costaClubNumber = null)
    {
        // validation for constraint: string
        if (!is_null($costaClubNumber) && !is_string($costaClubNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costaClubNumber)), __LINE__);
        }
        $this->CostaClubNumber = $costaClubNumber;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\GuestDocument|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\GuestDocument $document
     * @return \StructType\Guest
     */
    public function setDocument(\StructType\GuestDocument $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get RevisionControl value
     * @return \StructType\GuestRevisionControl|null
     */
    public function getRevisionControl()
    {
        return $this->RevisionControl;
    }
    /**
     * Set RevisionControl value
     * @param \StructType\GuestRevisionControl $revisionControl
     * @return \StructType\Guest
     */
    public function setRevisionControl(\StructType\GuestRevisionControl $revisionControl = null)
    {
        $this->RevisionControl = $revisionControl;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Guest
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get Phone value
     * @return \StructType\ContactPhone|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \StructType\ContactPhone $phone
     * @return \StructType\Guest
     */
    public function setPhone(\StructType\ContactPhone $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Documents value
     * @return \ArrayType\ArrayOfGuestDocument|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \ArrayType\ArrayOfGuestDocument $documents
     * @return \StructType\Guest
     */
    public function setDocuments(\ArrayType\ArrayOfGuestDocument $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get MCHotel value
     * @return \ArrayType\ArrayOfMCHotel|null
     */
    public function getMCHotel()
    {
        return $this->MCHotel;
    }
    /**
     * Set MCHotel value
     * @param \ArrayType\ArrayOfMCHotel $mCHotel
     * @return \StructType\Guest
     */
    public function setMCHotel(\ArrayType\ArrayOfMCHotel $mCHotel = null)
    {
        $this->MCHotel = $mCHotel;
        return $this;
    }
    /**
     * Get MCTransportation value
     * @return \ArrayType\ArrayOfMCTransportation|null
     */
    public function getMCTransportation()
    {
        return $this->MCTransportation;
    }
    /**
     * Set MCTransportation value
     * @param \ArrayType\ArrayOfMCTransportation $mCTransportation
     * @return \StructType\Guest
     */
    public function setMCTransportation(\ArrayType\ArrayOfMCTransportation $mCTransportation = null)
    {
        $this->MCTransportation = $mCTransportation;
        return $this;
    }
    /**
     * Get TTGSequence value
     * @return string|null
     */
    public function getTTGSequence()
    {
        return $this->TTGSequence;
    }
    /**
     * Set TTGSequence value
     * @param string $tTGSequence
     * @return \StructType\Guest
     */
    public function setTTGSequence($tTGSequence = null)
    {
        // validation for constraint: string
        if (!is_null($tTGSequence) && !is_string($tTGSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tTGSequence)), __LINE__);
        }
        $this->TTGSequence = $tTGSequence;
        return $this;
    }
    /**
     * Get CabinInfo value
     * @return \ArrayType\ArrayOfGuestCabinInfo|null
     */
    public function getCabinInfo()
    {
        return $this->CabinInfo;
    }
    /**
     * Set CabinInfo value
     * @param \ArrayType\ArrayOfGuestCabinInfo $cabinInfo
     * @return \StructType\Guest
     */
    public function setCabinInfo(\ArrayType\ArrayOfGuestCabinInfo $cabinInfo = null)
    {
        $this->CabinInfo = $cabinInfo;
        return $this;
    }
    /**
     * Get MultiCruiseInsurance value
     * @return \StructType\MultiCruiseInsurance|null
     */
    public function getMultiCruiseInsurance()
    {
        return $this->MultiCruiseInsurance;
    }
    /**
     * Set MultiCruiseInsurance value
     * @param \StructType\MultiCruiseInsurance $multiCruiseInsurance
     * @return \StructType\Guest
     */
    public function setMultiCruiseInsurance(\StructType\MultiCruiseInsurance $multiCruiseInsurance = null)
    {
        $this->MultiCruiseInsurance = $multiCruiseInsurance;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\Guest
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get ActionCodeTTG value
     * @return string|null
     */
    public function getActionCodeTTG()
    {
        return $this->ActionCodeTTG;
    }
    /**
     * Set ActionCodeTTG value
     * @param string $actionCodeTTG
     * @return \StructType\Guest
     */
    public function setActionCodeTTG($actionCodeTTG = null)
    {
        // validation for constraint: string
        if (!is_null($actionCodeTTG) && !is_string($actionCodeTTG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionCodeTTG)), __LINE__);
        }
        $this->ActionCodeTTG = $actionCodeTTG;
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \ArrayType\ArrayOfSpecialServices|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \ArrayType\ArrayOfSpecialServices $specialServices
     * @return \StructType\Guest
     */
    public function setSpecialServices(\ArrayType\ArrayOfSpecialServices $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Get ExtendedProperties value
     * @return \StructType\ExtendedProperties|null
     */
    public function getExtendedProperties()
    {
        return $this->ExtendedProperties;
    }
    /**
     * Set ExtendedProperties value
     * @param \StructType\ExtendedProperties $extendedProperties
     * @return \StructType\Guest
     */
    public function setExtendedProperties(\StructType\ExtendedProperties $extendedProperties = null)
    {
        $this->ExtendedProperties = $extendedProperties;
        return $this;
    }
    /**
     * Get AgeAmount value
     * @return string|null
     */
    public function getAgeAmount()
    {
        return $this->AgeAmount;
    }
    /**
     * Set AgeAmount value
     * @param string $ageAmount
     * @return \StructType\Guest
     */
    public function setAgeAmount($ageAmount = null)
    {
        // validation for constraint: string
        if (!is_null($ageAmount) && !is_string($ageAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ageAmount)), __LINE__);
        }
        $this->AgeAmount = $ageAmount;
        return $this;
    }
    /**
     * Get PaxId value
     * @return string|null
     */
    public function getPaxId()
    {
        return $this->PaxId;
    }
    /**
     * Set PaxId value
     * @param string $paxId
     * @return \StructType\Guest
     */
    public function setPaxId($paxId = null)
    {
        // validation for constraint: string
        if (!is_null($paxId) && !is_string($paxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paxId)), __LINE__);
        }
        $this->PaxId = $paxId;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Guest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get WebCheckIn value
     * @return \StructType\WebCheckIn|null
     */
    public function getWebCheckIn()
    {
        return $this->WebCheckIn;
    }
    /**
     * Set WebCheckIn value
     * @param \StructType\WebCheckIn $webCheckIn
     * @return \StructType\Guest
     */
    public function setWebCheckIn(\StructType\WebCheckIn $webCheckIn = null)
    {
        $this->WebCheckIn = $webCheckIn;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Guest
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get SpecialItems value
     * @return \ArrayType\ArrayOfSpecialItem|null
     */
    public function getSpecialItems()
    {
        return $this->SpecialItems;
    }
    /**
     * Set SpecialItems value
     * @param \ArrayType\ArrayOfSpecialItem $specialItems
     * @return \StructType\Guest
     */
    public function setSpecialItems(\ArrayType\ArrayOfSpecialItem $specialItems = null)
    {
        $this->SpecialItems = $specialItems;
        return $this;
    }
    /**
     * Get PrivacyInfo value
     * @return \StructType\PrivacyInfo|null
     */
    public function getPrivacyInfo()
    {
        return $this->PrivacyInfo;
    }
    /**
     * Set PrivacyInfo value
     * @param \StructType\PrivacyInfo $privacyInfo
     * @return \StructType\Guest
     */
    public function setPrivacyInfo(\StructType\PrivacyInfo $privacyInfo = null)
    {
        $this->PrivacyInfo = $privacyInfo;
        return $this;
    }
    /**
     * Get Compensations value
     * @return \ArrayType\ArrayOfCompensation|null
     */
    public function getCompensations()
    {
        return $this->Compensations;
    }
    /**
     * Set Compensations value
     * @param \ArrayType\ArrayOfCompensation $compensations
     * @return \StructType\Guest
     */
    public function setCompensations(\ArrayType\ArrayOfCompensation $compensations = null)
    {
        $this->Compensations = $compensations;
        return $this;
    }
    /**
     * Get Privacy value
     * @return \StructType\Privacy|null
     */
    public function getPrivacy()
    {
        return $this->Privacy;
    }
    /**
     * Set Privacy value
     * @param \StructType\Privacy $privacy
     * @return \StructType\Guest
     */
    public function setPrivacy(\StructType\Privacy $privacy = null)
    {
        $this->Privacy = $privacy;
        return $this;
    }
    /**
     * Get PartnerLoyalty value
     * @return \StructType\PartnerLoyalty|null
     */
    public function getPartnerLoyalty()
    {
        return $this->PartnerLoyalty;
    }
    /**
     * Set PartnerLoyalty value
     * @param \StructType\PartnerLoyalty $partnerLoyalty
     * @return \StructType\Guest
     */
    public function setPartnerLoyalty(\StructType\PartnerLoyalty $partnerLoyalty = null)
    {
        $this->PartnerLoyalty = $partnerLoyalty;
        return $this;
    }
    /**
     * Get TravelInfo value
     * @return \StructType\TravelInfo|null
     */
    public function getTravelInfo()
    {
        return $this->TravelInfo;
    }
    /**
     * Set TravelInfo value
     * @param \StructType\TravelInfo $travelInfo
     * @return \StructType\Guest
     */
    public function setTravelInfo(\StructType\TravelInfo $travelInfo = null)
    {
        $this->TravelInfo = $travelInfo;
        return $this;
    }
    /**
     * Get FiscalCode value
     * @return string|null
     */
    public function getFiscalCode()
    {
        return $this->FiscalCode;
    }
    /**
     * Set FiscalCode value
     * @param string $fiscalCode
     * @return \StructType\Guest
     */
    public function setFiscalCode($fiscalCode = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalCode) && !is_string($fiscalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fiscalCode)), __LINE__);
        }
        $this->FiscalCode = $fiscalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Guest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
