<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCruise StructType
 * @subpackage Structs
 */
class GetCruise extends AbstractStructBase
{
    /**
     * The CruiseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseCode;
    /**
     * Constructor method for GetCruise
     * @uses GetCruise::setCruiseCode()
     * @param string $cruiseCode
     */
    public function __construct($cruiseCode = null)
    {
        $this
            ->setCruiseCode($cruiseCode);
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\GetCruise
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCruise
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
