<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmercencyInfo StructType
 * @subpackage Structs
 */
class EmercencyInfo extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelephoneNumber;
    /**
     * The CruiseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseId;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The Relationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Relationship;
    /**
     * The SequenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SequenceNumber;
    /**
     * The PersonalPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonalPhoneNumber;
    /**
     * Constructor method for EmercencyInfo
     * @uses EmercencyInfo::setFirstName()
     * @uses EmercencyInfo::setLastName()
     * @uses EmercencyInfo::setTelephoneNumber()
     * @uses EmercencyInfo::setCruiseId()
     * @uses EmercencyInfo::setMiddleName()
     * @uses EmercencyInfo::setRelationship()
     * @uses EmercencyInfo::setSequenceNumber()
     * @uses EmercencyInfo::setPersonalPhoneNumber()
     * @param string $firstName
     * @param string $lastName
     * @param string $telephoneNumber
     * @param string $cruiseId
     * @param string $middleName
     * @param string $relationship
     * @param string $sequenceNumber
     * @param string $personalPhoneNumber
     */
    public function __construct($firstName = null, $lastName = null, $telephoneNumber = null, $cruiseId = null, $middleName = null, $relationship = null, $sequenceNumber = null, $personalPhoneNumber = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setTelephoneNumber($telephoneNumber)
            ->setCruiseId($cruiseId)
            ->setMiddleName($middleName)
            ->setRelationship($relationship)
            ->setSequenceNumber($sequenceNumber)
            ->setPersonalPhoneNumber($personalPhoneNumber);
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\EmercencyInfo
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\EmercencyInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\EmercencyInfo
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get CruiseId value
     * @return string|null
     */
    public function getCruiseId()
    {
        return $this->CruiseId;
    }
    /**
     * Set CruiseId value
     * @param string $cruiseId
     * @return \StructType\EmercencyInfo
     */
    public function setCruiseId($cruiseId = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseId) && !is_string($cruiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseId)), __LINE__);
        }
        $this->CruiseId = $cruiseId;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\EmercencyInfo
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get Relationship value
     * @return string|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param string $relationship
     * @return \StructType\EmercencyInfo
     */
    public function setRelationship($relationship = null)
    {
        // validation for constraint: string
        if (!is_null($relationship) && !is_string($relationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationship)), __LINE__);
        }
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\EmercencyInfo
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get PersonalPhoneNumber value
     * @return string|null
     */
    public function getPersonalPhoneNumber()
    {
        return $this->PersonalPhoneNumber;
    }
    /**
     * Set PersonalPhoneNumber value
     * @param string $personalPhoneNumber
     * @return \StructType\EmercencyInfo
     */
    public function setPersonalPhoneNumber($personalPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($personalPhoneNumber) && !is_string($personalPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personalPhoneNumber)), __LINE__);
        }
        $this->PersonalPhoneNumber = $personalPhoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmercencyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
