<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiningInformation StructType
 * @subpackage Structs
 */
class DiningInformation extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Availability;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The AvailableNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvailableNum;
    /**
     * Constructor method for DiningInformation
     * @uses DiningInformation::setCode()
     * @uses DiningInformation::setAvailability()
     * @uses DiningInformation::setStatus()
     * @uses DiningInformation::setAvailableNum()
     * @param string $code
     * @param bool $availability
     * @param string $status
     * @param string $availableNum
     */
    public function __construct($code = null, $availability = null, $status = null, $availableNum = null)
    {
        $this
            ->setCode($code)
            ->setAvailability($availability)
            ->setStatus($status)
            ->setAvailableNum($availableNum);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\Dining::valueIsValid()
     * @uses \EnumType\Dining::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\DiningInformation
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Dining::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\Dining::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Availability value
     * @return bool
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param bool $availability
     * @return \StructType\DiningInformation
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: boolean
        if (!is_null($availability) && !is_bool($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\DiningInformation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AvailableNum value
     * @return string|null
     */
    public function getAvailableNum()
    {
        return $this->AvailableNum;
    }
    /**
     * Set AvailableNum value
     * @param string $availableNum
     * @return \StructType\DiningInformation
     */
    public function setAvailableNum($availableNum = null)
    {
        // validation for constraint: string
        if (!is_null($availableNum) && !is_string($availableNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableNum)), __LINE__);
        }
        $this->AvailableNum = $availableNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiningInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
