<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cruise StructType
 * @subpackage Structs
 */
class Cruise extends AbstractStructBase
{
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Availability;
    /**
     * The Sellability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sellability;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureDate;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The MaxOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Destination
     */
    public $Destination;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Itinerary
     */
    public $Itinerary;
    /**
     * The DeparturePort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $DeparturePort;
    /**
     * The ArrivalPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $ArrivalPort;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Ship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ship
     */
    public $Ship;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdditionaInfo
     */
    public $AdditionalInfo;
    /**
     * The ImmediateConfirm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImmediateConfirm
     */
    public $ImmediateConfirm;
    /**
     * The AirRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirRemarks;
    /**
     * The CruiseRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruiseRemarks;
    /**
     * The ShoppingByPriceData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShoppingByPriceData
     */
    public $ShoppingByPriceData;
    /**
     * Constructor method for Cruise
     * @uses Cruise::setAvailability()
     * @uses Cruise::setSellability()
     * @uses Cruise::setDepartureDate()
     * @uses Cruise::setDuration()
     * @uses Cruise::setMaxOccupancy()
     * @uses Cruise::setCode()
     * @uses Cruise::setDestination()
     * @uses Cruise::setItinerary()
     * @uses Cruise::setDeparturePort()
     * @uses Cruise::setArrivalPort()
     * @uses Cruise::setDescription()
     * @uses Cruise::setShip()
     * @uses Cruise::setAdditionalInfo()
     * @uses Cruise::setImmediateConfirm()
     * @uses Cruise::setAirRemarks()
     * @uses Cruise::setCruiseRemarks()
     * @uses Cruise::setShoppingByPriceData()
     * @param bool $availability
     * @param bool $sellability
     * @param string $departureDate
     * @param int $duration
     * @param int $maxOccupancy
     * @param string $code
     * @param \StructType\Destination $destination
     * @param \StructType\Itinerary $itinerary
     * @param \StructType\City $departurePort
     * @param \StructType\City $arrivalPort
     * @param string $description
     * @param \StructType\Ship $ship
     * @param \StructType\AdditionaInfo $additionalInfo
     * @param \StructType\ImmediateConfirm $immediateConfirm
     * @param string $airRemarks
     * @param string $cruiseRemarks
     * @param \StructType\ShoppingByPriceData $shoppingByPriceData
     */
    public function __construct($availability = null, $sellability = null, $departureDate = null, $duration = null, $maxOccupancy = null, $code = null, \StructType\Destination $destination = null, \StructType\Itinerary $itinerary = null, \StructType\City $departurePort = null, \StructType\City $arrivalPort = null, $description = null, \StructType\Ship $ship = null, \StructType\AdditionaInfo $additionalInfo = null, \StructType\ImmediateConfirm $immediateConfirm = null, $airRemarks = null, $cruiseRemarks = null, \StructType\ShoppingByPriceData $shoppingByPriceData = null)
    {
        $this
            ->setAvailability($availability)
            ->setSellability($sellability)
            ->setDepartureDate($departureDate)
            ->setDuration($duration)
            ->setMaxOccupancy($maxOccupancy)
            ->setCode($code)
            ->setDestination($destination)
            ->setItinerary($itinerary)
            ->setDeparturePort($departurePort)
            ->setArrivalPort($arrivalPort)
            ->setDescription($description)
            ->setShip($ship)
            ->setAdditionalInfo($additionalInfo)
            ->setImmediateConfirm($immediateConfirm)
            ->setAirRemarks($airRemarks)
            ->setCruiseRemarks($cruiseRemarks)
            ->setShoppingByPriceData($shoppingByPriceData);
    }
    /**
     * Get Availability value
     * @return bool
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param bool $availability
     * @return \StructType\Cruise
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: boolean
        if (!is_null($availability) && !is_bool($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get Sellability value
     * @return bool
     */
    public function getSellability()
    {
        return $this->Sellability;
    }
    /**
     * Set Sellability value
     * @param bool $sellability
     * @return \StructType\Cruise
     */
    public function setSellability($sellability = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellability) && !is_bool($sellability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sellability)), __LINE__);
        }
        $this->Sellability = $sellability;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\Cruise
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\Cruise
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\Cruise
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !is_numeric($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Cruise
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Destination value
     * @return \StructType\Destination|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param \StructType\Destination $destination
     * @return \StructType\Cruise
     */
    public function setDestination(\StructType\Destination $destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \StructType\Itinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \StructType\Itinerary $itinerary
     * @return \StructType\Cruise
     */
    public function setItinerary(\StructType\Itinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get DeparturePort value
     * @return \StructType\City|null
     */
    public function getDeparturePort()
    {
        return $this->DeparturePort;
    }
    /**
     * Set DeparturePort value
     * @param \StructType\City $departurePort
     * @return \StructType\Cruise
     */
    public function setDeparturePort(\StructType\City $departurePort = null)
    {
        $this->DeparturePort = $departurePort;
        return $this;
    }
    /**
     * Get ArrivalPort value
     * @return \StructType\City|null
     */
    public function getArrivalPort()
    {
        return $this->ArrivalPort;
    }
    /**
     * Set ArrivalPort value
     * @param \StructType\City $arrivalPort
     * @return \StructType\Cruise
     */
    public function setArrivalPort(\StructType\City $arrivalPort = null)
    {
        $this->ArrivalPort = $arrivalPort;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Cruise
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\Ship $ship
     * @return \StructType\Cruise
     */
    public function setShip(\StructType\Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\AdditionaInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\AdditionaInfo $additionalInfo
     * @return \StructType\Cruise
     */
    public function setAdditionalInfo(\StructType\AdditionaInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get ImmediateConfirm value
     * @return \StructType\ImmediateConfirm|null
     */
    public function getImmediateConfirm()
    {
        return $this->ImmediateConfirm;
    }
    /**
     * Set ImmediateConfirm value
     * @param \StructType\ImmediateConfirm $immediateConfirm
     * @return \StructType\Cruise
     */
    public function setImmediateConfirm(\StructType\ImmediateConfirm $immediateConfirm = null)
    {
        $this->ImmediateConfirm = $immediateConfirm;
        return $this;
    }
    /**
     * Get AirRemarks value
     * @return string|null
     */
    public function getAirRemarks()
    {
        return $this->AirRemarks;
    }
    /**
     * Set AirRemarks value
     * @param string $airRemarks
     * @return \StructType\Cruise
     */
    public function setAirRemarks($airRemarks = null)
    {
        // validation for constraint: string
        if (!is_null($airRemarks) && !is_string($airRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airRemarks)), __LINE__);
        }
        $this->AirRemarks = $airRemarks;
        return $this;
    }
    /**
     * Get CruiseRemarks value
     * @return string|null
     */
    public function getCruiseRemarks()
    {
        return $this->CruiseRemarks;
    }
    /**
     * Set CruiseRemarks value
     * @param string $cruiseRemarks
     * @return \StructType\Cruise
     */
    public function setCruiseRemarks($cruiseRemarks = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseRemarks) && !is_string($cruiseRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cruiseRemarks)), __LINE__);
        }
        $this->CruiseRemarks = $cruiseRemarks;
        return $this;
    }
    /**
     * Get ShoppingByPriceData value
     * @return \StructType\ShoppingByPriceData|null
     */
    public function getShoppingByPriceData()
    {
        return $this->ShoppingByPriceData;
    }
    /**
     * Set ShoppingByPriceData value
     * @param \StructType\ShoppingByPriceData $shoppingByPriceData
     * @return \StructType\Cruise
     */
    public function setShoppingByPriceData(\StructType\ShoppingByPriceData $shoppingByPriceData = null)
    {
        $this->ShoppingByPriceData = $shoppingByPriceData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Cruise
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
