<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinAvailabilityInfo StructType
 * @subpackage Structs
 */
class CabinAvailabilityInfo extends AbstractStructBase
{
    /**
     * The NumberOfCabins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfCabins;
    /**
     * Constructor method for CabinAvailabilityInfo
     * @uses CabinAvailabilityInfo::setNumberOfCabins()
     * @param int $numberOfCabins
     */
    public function __construct($numberOfCabins = null)
    {
        $this
            ->setNumberOfCabins($numberOfCabins);
    }
    /**
     * Get NumberOfCabins value
     * @return int
     */
    public function getNumberOfCabins()
    {
        return $this->NumberOfCabins;
    }
    /**
     * Set NumberOfCabins value
     * @param int $numberOfCabins
     * @return \StructType\CabinAvailabilityInfo
     */
    public function setNumberOfCabins($numberOfCabins = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCabins) && !is_numeric($numberOfCabins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfCabins)), __LINE__);
        }
        $this->NumberOfCabins = $numberOfCabins;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinAvailabilityInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
