<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bed StructType
 * @subpackage Structs
 */
class Bed extends AbstractStructBase
{
    /**
     * The BedCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BedCode;
    /**
     * The NumberOfBeds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfBeds;
    /**
     * Constructor method for Bed
     * @uses Bed::setBedCode()
     * @uses Bed::setNumberOfBeds()
     * @param string $bedCode
     * @param int $numberOfBeds
     */
    public function __construct($bedCode = null, $numberOfBeds = null)
    {
        $this
            ->setBedCode($bedCode)
            ->setNumberOfBeds($numberOfBeds);
    }
    /**
     * Get BedCode value
     * @return string
     */
    public function getBedCode()
    {
        return $this->BedCode;
    }
    /**
     * Set BedCode value
     * @uses \EnumType\BedCode::valueIsValid()
     * @uses \EnumType\BedCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bedCode
     * @return \StructType\Bed
     */
    public function setBedCode($bedCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BedCode::valueIsValid($bedCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bedCode, implode(', ', \EnumType\BedCode::getValidValues())), __LINE__);
        }
        $this->BedCode = $bedCode;
        return $this;
    }
    /**
     * Get NumberOfBeds value
     * @return int
     */
    public function getNumberOfBeds()
    {
        return $this->NumberOfBeds;
    }
    /**
     * Set NumberOfBeds value
     * @param int $numberOfBeds
     * @return \StructType\Bed
     */
    public function setNumberOfBeds($numberOfBeds = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBeds) && !is_numeric($numberOfBeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBeds)), __LINE__);
        }
        $this->NumberOfBeds = $numberOfBeds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Bed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
