<?php

namespace EnumType;

/**
 * This class stands for TransportationType EnumType
 * @subpackage Enumerations
 */
class TransportationType
{
    /**
     * Constant for value 'Flight'
     * @return string 'Flight'
     */
    const VALUE_FLIGHT = 'Flight';
    /**
     * Constant for value 'Bus'
     * @return string 'Bus'
     */
    const VALUE_BUS = 'Bus';
    /**
     * Constant for value 'Transfer'
     * @return string 'Transfer'
     */
    const VALUE_TRANSFER = 'Transfer';
    /**
     * Constant for value 'Train'
     * @return string 'Train'
     */
    const VALUE_TRAIN = 'Train';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FLIGHT
     * @uses self::VALUE_BUS
     * @uses self::VALUE_TRANSFER
     * @uses self::VALUE_TRAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FLIGHT,
            self::VALUE_BUS,
            self::VALUE_TRANSFER,
            self::VALUE_TRAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
