<?php

namespace EnumType;

/**
 * This class stands for Direction EnumType
 * @subpackage Enumerations
 */
class Direction
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'InBound'
     * @return string 'InBound'
     */
    const VALUE_IN_BOUND = 'InBound';
    /**
     * Constant for value 'OutBound'
     * @return string 'OutBound'
     */
    const VALUE_OUT_BOUND = 'OutBound';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_IN_BOUND
     * @uses self::VALUE_OUT_BOUND
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_IN_BOUND,
            self::VALUE_OUT_BOUND,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
