<?php

namespace EnumType;

/**
 * This class stands for CategoryTypePrices EnumType
 * @subpackage Enumerations
 */
class CategoryTypePrices
{
    /**
     * Constant for value 'P1stAdult'
     * @return string 'P1stAdult'
     */
    const VALUE_P_1_ST_ADULT = 'P1stAdult';
    /**
     * Constant for value 'P2ndAdult'
     * @return string 'P2ndAdult'
     */
    const VALUE_P_2_ND_ADULT = 'P2ndAdult';
    /**
     * Constant for value 'P3rdAdult'
     * @return string 'P3rdAdult'
     */
    const VALUE_P_3_RD_ADULT = 'P3rdAdult';
    /**
     * Constant for value 'P3rdChild'
     * @return string 'P3rdChild'
     */
    const VALUE_P_3_RD_CHILD = 'P3rdChild';
    /**
     * Constant for value 'P3rdJunior'
     * @return string 'P3rdJunior'
     */
    const VALUE_P_3_RD_JUNIOR = 'P3rdJunior';
    /**
     * Constant for value 'PTotal'
     * @return string 'PTotal'
     */
    const VALUE_PTOTAL = 'PTotal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_P_1_ST_ADULT
     * @uses self::VALUE_P_2_ND_ADULT
     * @uses self::VALUE_P_3_RD_ADULT
     * @uses self::VALUE_P_3_RD_CHILD
     * @uses self::VALUE_P_3_RD_JUNIOR
     * @uses self::VALUE_PTOTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_P_1_ST_ADULT,
            self::VALUE_P_2_ND_ADULT,
            self::VALUE_P_3_RD_ADULT,
            self::VALUE_P_3_RD_CHILD,
            self::VALUE_P_3_RD_JUNIOR,
            self::VALUE_PTOTAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
