<?php

namespace EnumType;

/**
 * This class stands for BedCode EnumType
 * @subpackage Enumerations
 */
class BedCode
{
    /**
     * Constant for value 'Convertible'
     * @return string 'Convertible'
     */
    const VALUE_CONVERTIBLE = 'Convertible';
    /**
     * Constant for value 'Queen'
     * @return string 'Queen'
     */
    const VALUE_QUEEN = 'Queen';
    /**
     * Constant for value 'Sofa'
     * @return string 'Sofa'
     */
    const VALUE_SOFA = 'Sofa';
    /**
     * Constant for value 'Upper'
     * @return string 'Upper'
     */
    const VALUE_UPPER = 'Upper';
    /**
     * Constant for value 'RollBed'
     * @return string 'RollBed'
     */
    const VALUE_ROLL_BED = 'RollBed';
    /**
     * Constant for value 'BabyCot'
     * @return string 'BabyCot'
     */
    const VALUE_BABY_COT = 'BabyCot';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONVERTIBLE
     * @uses self::VALUE_QUEEN
     * @uses self::VALUE_SOFA
     * @uses self::VALUE_UPPER
     * @uses self::VALUE_ROLL_BED
     * @uses self::VALUE_BABY_COT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONVERTIBLE,
            self::VALUE_QUEEN,
            self::VALUE_SOFA,
            self::VALUE_UPPER,
            self::VALUE_ROLL_BED,
            self::VALUE_BABY_COT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
