<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialServices ArrayType
 * @subpackage Arrays
 */
class ArrayOfSpecialServices extends AbstractStructArrayBase
{
    /**
     * The SpecialServices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SpecialServices[]
     */
    public $SpecialServices;
    /**
     * Constructor method for ArrayOfSpecialServices
     * @uses ArrayOfSpecialServices::setSpecialServices()
     * @param \StructType\SpecialServices[] $specialServices
     */
    public function __construct(array $specialServices = array())
    {
        $this
            ->setSpecialServices($specialServices);
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SpecialServices[]|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServices[] $specialServices
     * @return \ArrayType\ArrayOfSpecialServices
     */
    public function setSpecialServices(array $specialServices = array())
    {
        foreach ($specialServices as $arrayOfSpecialServicesSpecialServicesItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialServicesSpecialServicesItem instanceof \StructType\SpecialServices) {
                throw new \InvalidArgumentException(sprintf('The SpecialServices property can only contain items of \StructType\SpecialServices, "%s" given', is_object($arrayOfSpecialServicesSpecialServicesItem) ? get_class($arrayOfSpecialServicesSpecialServicesItem) : gettype($arrayOfSpecialServicesSpecialServicesItem)), __LINE__);
            }
        }
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
    /**
     * Add item to SpecialServices value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServices $item
     * @return \ArrayType\ArrayOfSpecialServices
     */
    public function addToSpecialServices(\StructType\SpecialServices $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialServices) {
            throw new \InvalidArgumentException(sprintf('The SpecialServices property can only contain items of \StructType\SpecialServices, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialServices[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SpecialServices|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SpecialServices|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SpecialServices|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SpecialServices|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SpecialServices|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialServices
     */
    public function getAttributeName()
    {
        return 'SpecialServices';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSpecialServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
