<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSegment ArrayType
 * @subpackage Arrays
 */
class ArrayOfSegment extends AbstractStructArrayBase
{
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for ArrayOfSegment
     * @uses ArrayOfSegment::setSegment()
     * @param \StructType\Segment[] $segment
     */
    public function __construct(array $segment = array())
    {
        $this
            ->setSegment($segment);
    }
    /**
     * Get Segment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Segment[]|null
     */
    public function getSegment()
    {
        return isset($this->Segment) ? $this->Segment : null;
    }
    /**
     * Set Segment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Segment[] $segment
     * @return \ArrayType\ArrayOfSegment
     */
    public function setSegment(array $segment = array())
    {
        foreach ($segment as $arrayOfSegmentSegmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfSegmentSegmentItem instanceof \StructType\Segment) {
                throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of \StructType\Segment, "%s" given', is_object($arrayOfSegmentSegmentItem) ? get_class($arrayOfSegmentSegmentItem) : gettype($arrayOfSegmentSegmentItem)), __LINE__);
            }
        }
        if (is_null($segment) || (is_array($segment) && empty($segment))) {
            unset($this->Segment);
        } else {
            $this->Segment = $segment;
        }
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\Segment $item
     * @return \ArrayType\ArrayOfSegment
     */
    public function addToSegment(\StructType\Segment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Segment) {
            throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of \StructType\Segment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Segment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Segment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Segment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Segment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Segment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Segment
     */
    public function getAttributeName()
    {
        return 'Segment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
