<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfScore ArrayType
 * @subpackage Arrays
 */
class ArrayOfScore extends AbstractStructArrayBase
{
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Score[]
     */
    public $Score;
    /**
     * Constructor method for ArrayOfScore
     * @uses ArrayOfScore::setScore()
     * @param \StructType\Score[] $score
     */
    public function __construct(array $score = array())
    {
        $this
            ->setScore($score);
    }
    /**
     * Get Score value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Score[]|null
     */
    public function getScore()
    {
        return isset($this->Score) ? $this->Score : null;
    }
    /**
     * Set Score value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Score[] $score
     * @return \ArrayType\ArrayOfScore
     */
    public function setScore(array $score = array())
    {
        foreach ($score as $arrayOfScoreScoreItem) {
            // validation for constraint: itemType
            if (!$arrayOfScoreScoreItem instanceof \StructType\Score) {
                throw new \InvalidArgumentException(sprintf('The Score property can only contain items of \StructType\Score, "%s" given', is_object($arrayOfScoreScoreItem) ? get_class($arrayOfScoreScoreItem) : gettype($arrayOfScoreScoreItem)), __LINE__);
            }
        }
        if (is_null($score) || (is_array($score) && empty($score))) {
            unset($this->Score);
        } else {
            $this->Score = $score;
        }
        return $this;
    }
    /**
     * Add item to Score value
     * @throws \InvalidArgumentException
     * @param \StructType\Score $item
     * @return \ArrayType\ArrayOfScore
     */
    public function addToScore(\StructType\Score $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Score) {
            throw new \InvalidArgumentException(sprintf('The Score property can only contain items of \StructType\Score, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Score[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Score|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Score|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Score|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Score|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Score|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Score
     */
    public function getAttributeName()
    {
        return 'Score';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfScore
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
