<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPublicArea ArrayType
 * @subpackage Arrays
 */
class ArrayOfPublicArea extends AbstractStructArrayBase
{
    /**
     * The PublicArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PublicArea[]
     */
    public $PublicArea;
    /**
     * Constructor method for ArrayOfPublicArea
     * @uses ArrayOfPublicArea::setPublicArea()
     * @param \StructType\PublicArea[] $publicArea
     */
    public function __construct(array $publicArea = array())
    {
        $this
            ->setPublicArea($publicArea);
    }
    /**
     * Get PublicArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PublicArea[]|null
     */
    public function getPublicArea()
    {
        return isset($this->PublicArea) ? $this->PublicArea : null;
    }
    /**
     * Set PublicArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PublicArea[] $publicArea
     * @return \ArrayType\ArrayOfPublicArea
     */
    public function setPublicArea(array $publicArea = array())
    {
        foreach ($publicArea as $arrayOfPublicAreaPublicAreaItem) {
            // validation for constraint: itemType
            if (!$arrayOfPublicAreaPublicAreaItem instanceof \StructType\PublicArea) {
                throw new \InvalidArgumentException(sprintf('The PublicArea property can only contain items of \StructType\PublicArea, "%s" given', is_object($arrayOfPublicAreaPublicAreaItem) ? get_class($arrayOfPublicAreaPublicAreaItem) : gettype($arrayOfPublicAreaPublicAreaItem)), __LINE__);
            }
        }
        if (is_null($publicArea) || (is_array($publicArea) && empty($publicArea))) {
            unset($this->PublicArea);
        } else {
            $this->PublicArea = $publicArea;
        }
        return $this;
    }
    /**
     * Add item to PublicArea value
     * @throws \InvalidArgumentException
     * @param \StructType\PublicArea $item
     * @return \ArrayType\ArrayOfPublicArea
     */
    public function addToPublicArea(\StructType\PublicArea $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PublicArea) {
            throw new \InvalidArgumentException(sprintf('The PublicArea property can only contain items of \StructType\PublicArea, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PublicArea[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PublicArea|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PublicArea|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PublicArea|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PublicArea|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PublicArea|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PublicArea
     */
    public function getAttributeName()
    {
        return 'PublicArea';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPublicArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
