<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMCTransportation ArrayType
 * @subpackage Arrays
 */
class ArrayOfMCTransportation extends AbstractStructArrayBase
{
    /**
     * The MCTransportation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MCTransportation[]
     */
    public $MCTransportation;
    /**
     * Constructor method for ArrayOfMCTransportation
     * @uses ArrayOfMCTransportation::setMCTransportation()
     * @param \StructType\MCTransportation[] $mCTransportation
     */
    public function __construct(array $mCTransportation = array())
    {
        $this
            ->setMCTransportation($mCTransportation);
    }
    /**
     * Get MCTransportation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MCTransportation[]|null
     */
    public function getMCTransportation()
    {
        return isset($this->MCTransportation) ? $this->MCTransportation : null;
    }
    /**
     * Set MCTransportation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MCTransportation[] $mCTransportation
     * @return \ArrayType\ArrayOfMCTransportation
     */
    public function setMCTransportation(array $mCTransportation = array())
    {
        foreach ($mCTransportation as $arrayOfMCTransportationMCTransportationItem) {
            // validation for constraint: itemType
            if (!$arrayOfMCTransportationMCTransportationItem instanceof \StructType\MCTransportation) {
                throw new \InvalidArgumentException(sprintf('The MCTransportation property can only contain items of \StructType\MCTransportation, "%s" given', is_object($arrayOfMCTransportationMCTransportationItem) ? get_class($arrayOfMCTransportationMCTransportationItem) : gettype($arrayOfMCTransportationMCTransportationItem)), __LINE__);
            }
        }
        if (is_null($mCTransportation) || (is_array($mCTransportation) && empty($mCTransportation))) {
            unset($this->MCTransportation);
        } else {
            $this->MCTransportation = $mCTransportation;
        }
        return $this;
    }
    /**
     * Add item to MCTransportation value
     * @throws \InvalidArgumentException
     * @param \StructType\MCTransportation $item
     * @return \ArrayType\ArrayOfMCTransportation
     */
    public function addToMCTransportation(\StructType\MCTransportation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MCTransportation) {
            throw new \InvalidArgumentException(sprintf('The MCTransportation property can only contain items of \StructType\MCTransportation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MCTransportation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MCTransportation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MCTransportation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MCTransportation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MCTransportation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MCTransportation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MCTransportation
     */
    public function getAttributeName()
    {
        return 'MCTransportation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMCTransportation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
