<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGuestPrice ArrayType
 * @subpackage Arrays
 */
class ArrayOfGuestPrice extends AbstractStructArrayBase
{
    /**
     * The GuestPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GuestPrice[]
     */
    public $GuestPrice;
    /**
     * Constructor method for ArrayOfGuestPrice
     * @uses ArrayOfGuestPrice::setGuestPrice()
     * @param \StructType\GuestPrice[] $guestPrice
     */
    public function __construct(array $guestPrice = array())
    {
        $this
            ->setGuestPrice($guestPrice);
    }
    /**
     * Get GuestPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GuestPrice[]|null
     */
    public function getGuestPrice()
    {
        return isset($this->GuestPrice) ? $this->GuestPrice : null;
    }
    /**
     * Set GuestPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GuestPrice[] $guestPrice
     * @return \ArrayType\ArrayOfGuestPrice
     */
    public function setGuestPrice(array $guestPrice = array())
    {
        foreach ($guestPrice as $arrayOfGuestPriceGuestPriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfGuestPriceGuestPriceItem instanceof \StructType\GuestPrice) {
                throw new \InvalidArgumentException(sprintf('The GuestPrice property can only contain items of \StructType\GuestPrice, "%s" given', is_object($arrayOfGuestPriceGuestPriceItem) ? get_class($arrayOfGuestPriceGuestPriceItem) : gettype($arrayOfGuestPriceGuestPriceItem)), __LINE__);
            }
        }
        if (is_null($guestPrice) || (is_array($guestPrice) && empty($guestPrice))) {
            unset($this->GuestPrice);
        } else {
            $this->GuestPrice = $guestPrice;
        }
        return $this;
    }
    /**
     * Add item to GuestPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestPrice $item
     * @return \ArrayType\ArrayOfGuestPrice
     */
    public function addToGuestPrice(\StructType\GuestPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestPrice) {
            throw new \InvalidArgumentException(sprintf('The GuestPrice property can only contain items of \StructType\GuestPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GuestPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GuestPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GuestPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GuestPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GuestPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GuestPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GuestPrice
     */
    public function getAttributeName()
    {
        return 'GuestPrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGuestPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
