<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGuestDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfGuestDocument extends AbstractStructArrayBase
{
    /**
     * The GuestDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GuestDocument[]
     */
    public $GuestDocument;
    /**
     * Constructor method for ArrayOfGuestDocument
     * @uses ArrayOfGuestDocument::setGuestDocument()
     * @param \StructType\GuestDocument[] $guestDocument
     */
    public function __construct(array $guestDocument = array())
    {
        $this
            ->setGuestDocument($guestDocument);
    }
    /**
     * Get GuestDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GuestDocument[]|null
     */
    public function getGuestDocument()
    {
        return isset($this->GuestDocument) ? $this->GuestDocument : null;
    }
    /**
     * Set GuestDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GuestDocument[] $guestDocument
     * @return \ArrayType\ArrayOfGuestDocument
     */
    public function setGuestDocument(array $guestDocument = array())
    {
        foreach ($guestDocument as $arrayOfGuestDocumentGuestDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfGuestDocumentGuestDocumentItem instanceof \StructType\GuestDocument) {
                throw new \InvalidArgumentException(sprintf('The GuestDocument property can only contain items of \StructType\GuestDocument, "%s" given', is_object($arrayOfGuestDocumentGuestDocumentItem) ? get_class($arrayOfGuestDocumentGuestDocumentItem) : gettype($arrayOfGuestDocumentGuestDocumentItem)), __LINE__);
            }
        }
        if (is_null($guestDocument) || (is_array($guestDocument) && empty($guestDocument))) {
            unset($this->GuestDocument);
        } else {
            $this->GuestDocument = $guestDocument;
        }
        return $this;
    }
    /**
     * Add item to GuestDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestDocument $item
     * @return \ArrayType\ArrayOfGuestDocument
     */
    public function addToGuestDocument(\StructType\GuestDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestDocument) {
            throw new \InvalidArgumentException(sprintf('The GuestDocument property can only contain items of \StructType\GuestDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GuestDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GuestDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GuestDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GuestDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GuestDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GuestDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GuestDocument
     */
    public function getAttributeName()
    {
        return 'GuestDocument';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGuestDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
