<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFare ArrayType
 * @subpackage Arrays
 */
class ArrayOfFare extends AbstractStructArrayBase
{
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Fare[]
     */
    public $Fare;
    /**
     * Constructor method for ArrayOfFare
     * @uses ArrayOfFare::setFare()
     * @param \StructType\Fare[] $fare
     */
    public function __construct(array $fare = array())
    {
        $this
            ->setFare($fare);
    }
    /**
     * Get Fare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Fare[]|null
     */
    public function getFare()
    {
        return isset($this->Fare) ? $this->Fare : null;
    }
    /**
     * Set Fare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Fare[] $fare
     * @return \ArrayType\ArrayOfFare
     */
    public function setFare(array $fare = array())
    {
        foreach ($fare as $arrayOfFareFareItem) {
            // validation for constraint: itemType
            if (!$arrayOfFareFareItem instanceof \StructType\Fare) {
                throw new \InvalidArgumentException(sprintf('The Fare property can only contain items of \StructType\Fare, "%s" given', is_object($arrayOfFareFareItem) ? get_class($arrayOfFareFareItem) : gettype($arrayOfFareFareItem)), __LINE__);
            }
        }
        if (is_null($fare) || (is_array($fare) && empty($fare))) {
            unset($this->Fare);
        } else {
            $this->Fare = $fare;
        }
        return $this;
    }
    /**
     * Add item to Fare value
     * @throws \InvalidArgumentException
     * @param \StructType\Fare $item
     * @return \ArrayType\ArrayOfFare
     */
    public function addToFare(\StructType\Fare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fare) {
            throw new \InvalidArgumentException(sprintf('The Fare property can only contain items of \StructType\Fare, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fare[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Fare|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Fare|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Fare|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Fare|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Fare|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fare
     */
    public function getAttributeName()
    {
        return 'Fare';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
