<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompensation ArrayType
 * @subpackage Arrays
 */
class ArrayOfCompensation extends AbstractStructArrayBase
{
    /**
     * The Compensation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Compensation[]
     */
    public $Compensation;
    /**
     * Constructor method for ArrayOfCompensation
     * @uses ArrayOfCompensation::setCompensation()
     * @param \StructType\Compensation[] $compensation
     */
    public function __construct(array $compensation = array())
    {
        $this
            ->setCompensation($compensation);
    }
    /**
     * Get Compensation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Compensation[]|null
     */
    public function getCompensation()
    {
        return isset($this->Compensation) ? $this->Compensation : null;
    }
    /**
     * Set Compensation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Compensation[] $compensation
     * @return \ArrayType\ArrayOfCompensation
     */
    public function setCompensation(array $compensation = array())
    {
        foreach ($compensation as $arrayOfCompensationCompensationItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompensationCompensationItem instanceof \StructType\Compensation) {
                throw new \InvalidArgumentException(sprintf('The Compensation property can only contain items of \StructType\Compensation, "%s" given', is_object($arrayOfCompensationCompensationItem) ? get_class($arrayOfCompensationCompensationItem) : gettype($arrayOfCompensationCompensationItem)), __LINE__);
            }
        }
        if (is_null($compensation) || (is_array($compensation) && empty($compensation))) {
            unset($this->Compensation);
        } else {
            $this->Compensation = $compensation;
        }
        return $this;
    }
    /**
     * Add item to Compensation value
     * @throws \InvalidArgumentException
     * @param \StructType\Compensation $item
     * @return \ArrayType\ArrayOfCompensation
     */
    public function addToCompensation(\StructType\Compensation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Compensation) {
            throw new \InvalidArgumentException(sprintf('The Compensation property can only contain items of \StructType\Compensation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Compensation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Compensation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Compensation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Compensation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Compensation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Compensation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Compensation
     */
    public function getAttributeName()
    {
        return 'Compensation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCompensation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
