<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCabin ArrayType
 * @subpackage Arrays
 */
class ArrayOfCabin extends AbstractStructArrayBase
{
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Cabin[]
     */
    public $Cabin;
    /**
     * Constructor method for ArrayOfCabin
     * @uses ArrayOfCabin::setCabin()
     * @param \StructType\Cabin[] $cabin
     */
    public function __construct(array $cabin = array())
    {
        $this
            ->setCabin($cabin);
    }
    /**
     * Get Cabin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Cabin[]|null
     */
    public function getCabin()
    {
        return isset($this->Cabin) ? $this->Cabin : null;
    }
    /**
     * Set Cabin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cabin[] $cabin
     * @return \ArrayType\ArrayOfCabin
     */
    public function setCabin(array $cabin = array())
    {
        foreach ($cabin as $arrayOfCabinCabinItem) {
            // validation for constraint: itemType
            if (!$arrayOfCabinCabinItem instanceof \StructType\Cabin) {
                throw new \InvalidArgumentException(sprintf('The Cabin property can only contain items of \StructType\Cabin, "%s" given', is_object($arrayOfCabinCabinItem) ? get_class($arrayOfCabinCabinItem) : gettype($arrayOfCabinCabinItem)), __LINE__);
            }
        }
        if (is_null($cabin) || (is_array($cabin) && empty($cabin))) {
            unset($this->Cabin);
        } else {
            $this->Cabin = $cabin;
        }
        return $this;
    }
    /**
     * Add item to Cabin value
     * @throws \InvalidArgumentException
     * @param \StructType\Cabin $item
     * @return \ArrayType\ArrayOfCabin
     */
    public function addToCabin(\StructType\Cabin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cabin) {
            throw new \InvalidArgumentException(sprintf('The Cabin property can only contain items of \StructType\Cabin, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Cabin[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Cabin|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Cabin|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Cabin|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Cabin|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Cabin|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cabin
     */
    public function getAttributeName()
    {
        return 'Cabin';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCabin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
