<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZoneProjectionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for PROJECTION as a geospatial zone.
 * @subpackage Structs
 */
class ZoneProjectionStructure extends AbstractProjection
{
    /**
     * The Boundary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Boundary[]
     */
    public $Boundary;
    /**
     * Constructor method for ZoneProjectionStructure
     * @uses ZoneProjectionStructure::setBoundary()
     * @param \StructType\Boundary[] $boundary
     */
    public function __construct(array $boundary = array())
    {
        $this
            ->setBoundary($boundary);
    }
    /**
     * Get Boundary value
     * @return \StructType\Boundary[]|null
     */
    public function getBoundary()
    {
        return $this->Boundary;
    }
    /**
     * Set Boundary value
     * @throws \InvalidArgumentException
     * @param \StructType\Boundary[] $boundary
     * @return \StructType\ZoneProjectionStructure
     */
    public function setBoundary(array $boundary = array())
    {
        foreach ($boundary as $zoneProjectionStructureBoundaryItem) {
            // validation for constraint: itemType
            if (!$zoneProjectionStructureBoundaryItem instanceof \StructType\Boundary) {
                throw new \InvalidArgumentException(sprintf('The Boundary property can only contain items of \StructType\Boundary, "%s" given', is_object($zoneProjectionStructureBoundaryItem) ? get_class($zoneProjectionStructureBoundaryItem) : gettype($zoneProjectionStructureBoundaryItem)), __LINE__);
            }
        }
        $this->Boundary = $boundary;
        return $this;
    }
    /**
     * Add item to Boundary value
     * @throws \InvalidArgumentException
     * @param \StructType\Boundary $item
     * @return \StructType\ZoneProjectionStructure
     */
    public function addToBoundary(\StructType\Boundary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Boundary) {
            throw new \InvalidArgumentException(sprintf('The Boundary property can only contain items of \StructType\Boundary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Boundary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZoneProjectionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
