<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeatherRelatedRoadConditions StructType
 * @subpackage Structs
 */
class WeatherRelatedRoadConditions extends RoadConditions
{
    /**
     * The weatherRelatedRoadConditionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $weatherRelatedRoadConditionType;
    /**
     * The roadSurfaceConditionMeasurements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoadSurfaceConditionMeasurements
     */
    public $roadSurfaceConditionMeasurements;
    /**
     * The weatherRelatedRoadConditionsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $weatherRelatedRoadConditionsExtension;
    /**
     * Constructor method for WeatherRelatedRoadConditions
     * @uses WeatherRelatedRoadConditions::setWeatherRelatedRoadConditionType()
     * @uses WeatherRelatedRoadConditions::setRoadSurfaceConditionMeasurements()
     * @uses WeatherRelatedRoadConditions::setWeatherRelatedRoadConditionsExtension()
     * @param string[] $weatherRelatedRoadConditionType
     * @param \StructType\RoadSurfaceConditionMeasurements $roadSurfaceConditionMeasurements
     * @param \StructType\ExtensionType $weatherRelatedRoadConditionsExtension
     */
    public function __construct(array $weatherRelatedRoadConditionType = array(), \StructType\RoadSurfaceConditionMeasurements $roadSurfaceConditionMeasurements = null, \StructType\ExtensionType $weatherRelatedRoadConditionsExtension = null)
    {
        $this
            ->setWeatherRelatedRoadConditionType($weatherRelatedRoadConditionType)
            ->setRoadSurfaceConditionMeasurements($roadSurfaceConditionMeasurements)
            ->setWeatherRelatedRoadConditionsExtension($weatherRelatedRoadConditionsExtension);
    }
    /**
     * Get weatherRelatedRoadConditionType value
     * @return string[]
     */
    public function getWeatherRelatedRoadConditionType()
    {
        return $this->weatherRelatedRoadConditionType;
    }
    /**
     * Set weatherRelatedRoadConditionType value
     * @uses \EnumType\WeatherRelatedRoadConditionTypeEnum::valueIsValid()
     * @uses \EnumType\WeatherRelatedRoadConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $weatherRelatedRoadConditionType
     * @return \StructType\WeatherRelatedRoadConditions
     */
    public function setWeatherRelatedRoadConditionType(array $weatherRelatedRoadConditionType = array())
    {
        $invalidValues = array();
        foreach ($weatherRelatedRoadConditionType as $weatherRelatedRoadConditionsWeatherRelatedRoadConditionTypeItem) {
            if (!\EnumType\WeatherRelatedRoadConditionTypeEnum::valueIsValid($weatherRelatedRoadConditionsWeatherRelatedRoadConditionTypeItem)) {
                $invalidValues[] = var_export($weatherRelatedRoadConditionsWeatherRelatedRoadConditionTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\WeatherRelatedRoadConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->weatherRelatedRoadConditionType = $weatherRelatedRoadConditionType;
        return $this;
    }
    /**
     * Add item to weatherRelatedRoadConditionType value
     * @uses \EnumType\WeatherRelatedRoadConditionTypeEnum::valueIsValid()
     * @uses \EnumType\WeatherRelatedRoadConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WeatherRelatedRoadConditions
     */
    public function addToWeatherRelatedRoadConditionType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeatherRelatedRoadConditionTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\WeatherRelatedRoadConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->weatherRelatedRoadConditionType[] = $item;
        return $this;
    }
    /**
     * Get roadSurfaceConditionMeasurements value
     * @return \StructType\RoadSurfaceConditionMeasurements|null
     */
    public function getRoadSurfaceConditionMeasurements()
    {
        return $this->roadSurfaceConditionMeasurements;
    }
    /**
     * Set roadSurfaceConditionMeasurements value
     * @param \StructType\RoadSurfaceConditionMeasurements $roadSurfaceConditionMeasurements
     * @return \StructType\WeatherRelatedRoadConditions
     */
    public function setRoadSurfaceConditionMeasurements(\StructType\RoadSurfaceConditionMeasurements $roadSurfaceConditionMeasurements = null)
    {
        $this->roadSurfaceConditionMeasurements = $roadSurfaceConditionMeasurements;
        return $this;
    }
    /**
     * Get weatherRelatedRoadConditionsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getWeatherRelatedRoadConditionsExtension()
    {
        return $this->weatherRelatedRoadConditionsExtension;
    }
    /**
     * Set weatherRelatedRoadConditionsExtension value
     * @param \StructType\ExtensionType $weatherRelatedRoadConditionsExtension
     * @return \StructType\WeatherRelatedRoadConditions
     */
    public function setWeatherRelatedRoadConditionsExtension(\StructType\ExtensionType $weatherRelatedRoadConditionsExtension = null)
    {
        $this->weatherRelatedRoadConditionsExtension = $weatherRelatedRoadConditionsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WeatherRelatedRoadConditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
