<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaNameStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for VIA NAMes structure.
 * @subpackage Structs
 */
class ViaNameStructure extends PlaceNameStructure
{
    /**
     * The ViaPriority
     * Meta informations extracted from the WSDL
     * - default: 2
     * - documentation: Relative priority to give to VIA name in displays. 1=high. Default is 2. +SIRI v2.0
     * - minOccurs: 0
     * @var int
     */
    public $ViaPriority;
    /**
     * Constructor method for ViaNameStructure
     * @uses ViaNameStructure::setViaPriority()
     * @param int $viaPriority
     */
    public function __construct($viaPriority = '2')
    {
        $this
            ->setViaPriority($viaPriority);
    }
    /**
     * Get ViaPriority value
     * @return int|null
     */
    public function getViaPriority()
    {
        return $this->ViaPriority;
    }
    /**
     * Set ViaPriority value
     * @param int $viaPriority
     * @return \StructType\ViaNameStructure
     */
    public function setViaPriority($viaPriority = '2')
    {
        // validation for constraint: int
        if (!is_null($viaPriority) && !is_numeric($viaPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($viaPriority)), __LINE__);
        }
        $this->ViaPriority = $viaPriority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ViaNameStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
