<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Via StructType
 * Meta informations extracted from the WSDL
 * - documentation: VIA points for VEHICLE JOURNEY | Names of VIA points, used to help identify the LINE, for example, Luton to Luton via Sutton. Currently 3 in VDV. Should only be included if the detail level was requested.
 * - maxOccurs: unbounded
 * - minOccurs: 0
 * - type: ViaNameStructure
 * @subpackage Structs
 */
class Via extends AbstractStructBase
{
    /**
     * The ViaRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ViaRef
     * @var \StructType\JourneyPlaceRefStructure
     */
    public $ViaRef;
    /**
     * The ViaName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ViaName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $ViaName;
    /**
     * The PresentationPriority
     * Meta informations extracted from the WSDL
     * - documentation: Relative priority for incliding via in displays. 1 Is high 3 is low. +SIRI v2.0
     * - minOccurs: 0
     * @var int
     */
    public $PresentationPriority;
    /**
     * Constructor method for Via
     * @uses Via::setViaRef()
     * @uses Via::setViaName()
     * @uses Via::setPresentationPriority()
     * @param \StructType\JourneyPlaceRefStructure $viaRef
     * @param \StructType\NaturalLanguagePlaceNameStructure $viaName
     * @param int $presentationPriority
     */
    public function __construct(\StructType\JourneyPlaceRefStructure $viaRef = null, \StructType\NaturalLanguagePlaceNameStructure $viaName = null, $presentationPriority = null)
    {
        $this
            ->setViaRef($viaRef)
            ->setViaName($viaName)
            ->setPresentationPriority($presentationPriority);
    }
    /**
     * Get ViaRef value
     * @return \StructType\JourneyPlaceRefStructure|null
     */
    public function getViaRef()
    {
        return $this->ViaRef;
    }
    /**
     * Set ViaRef value
     * @param \StructType\JourneyPlaceRefStructure $viaRef
     * @return \StructType\Via
     */
    public function setViaRef(\StructType\JourneyPlaceRefStructure $viaRef = null)
    {
        $this->ViaRef = $viaRef;
        return $this;
    }
    /**
     * Get ViaName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getViaName()
    {
        return $this->ViaName;
    }
    /**
     * Set ViaName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $viaName
     * @return \StructType\Via
     */
    public function setViaName(\StructType\NaturalLanguagePlaceNameStructure $viaName = null)
    {
        $this->ViaName = $viaName;
        return $this;
    }
    /**
     * Get PresentationPriority value
     * @return int|null
     */
    public function getPresentationPriority()
    {
        return $this->PresentationPriority;
    }
    /**
     * Set PresentationPriority value
     * @param int $presentationPriority
     * @return \StructType\Via
     */
    public function setPresentationPriority($presentationPriority = null)
    {
        // validation for constraint: int
        if (!is_null($presentationPriority) && !is_numeric($presentationPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($presentationPriority)), __LINE__);
        }
        $this->PresentationPriority = $presentationPriority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Via
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
