<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleObstruction StructType
 * @subpackage Structs
 */
class VehicleObstruction extends Obstruction
{
    /**
     * The vehicleObstructionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vehicleObstructionType;
    /**
     * The obstructingVehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Vehicle[]
     */
    public $obstructingVehicle;
    /**
     * The vehicleObstructionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $vehicleObstructionExtension;
    /**
     * Constructor method for VehicleObstruction
     * @uses VehicleObstruction::setVehicleObstructionType()
     * @uses VehicleObstruction::setObstructingVehicle()
     * @uses VehicleObstruction::setVehicleObstructionExtension()
     * @param string $vehicleObstructionType
     * @param \StructType\Vehicle[] $obstructingVehicle
     * @param \StructType\ExtensionType $vehicleObstructionExtension
     */
    public function __construct($vehicleObstructionType = null, array $obstructingVehicle = array(), \StructType\ExtensionType $vehicleObstructionExtension = null)
    {
        $this
            ->setVehicleObstructionType($vehicleObstructionType)
            ->setObstructingVehicle($obstructingVehicle)
            ->setVehicleObstructionExtension($vehicleObstructionExtension);
    }
    /**
     * Get vehicleObstructionType value
     * @return string
     */
    public function getVehicleObstructionType()
    {
        return $this->vehicleObstructionType;
    }
    /**
     * Set vehicleObstructionType value
     * @uses \EnumType\VehicleObstructionTypeEnum::valueIsValid()
     * @uses \EnumType\VehicleObstructionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleObstructionType
     * @return \StructType\VehicleObstruction
     */
    public function setVehicleObstructionType($vehicleObstructionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleObstructionTypeEnum::valueIsValid($vehicleObstructionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleObstructionType, implode(', ', \EnumType\VehicleObstructionTypeEnum::getValidValues())), __LINE__);
        }
        $this->vehicleObstructionType = $vehicleObstructionType;
        return $this;
    }
    /**
     * Get obstructingVehicle value
     * @return \StructType\Vehicle[]|null
     */
    public function getObstructingVehicle()
    {
        return $this->obstructingVehicle;
    }
    /**
     * Set obstructingVehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicle[] $obstructingVehicle
     * @return \StructType\VehicleObstruction
     */
    public function setObstructingVehicle(array $obstructingVehicle = array())
    {
        foreach ($obstructingVehicle as $vehicleObstructionObstructingVehicleItem) {
            // validation for constraint: itemType
            if (!$vehicleObstructionObstructingVehicleItem instanceof \StructType\Vehicle) {
                throw new \InvalidArgumentException(sprintf('The obstructingVehicle property can only contain items of \StructType\Vehicle, "%s" given', is_object($vehicleObstructionObstructingVehicleItem) ? get_class($vehicleObstructionObstructingVehicleItem) : gettype($vehicleObstructionObstructingVehicleItem)), __LINE__);
            }
        }
        $this->obstructingVehicle = $obstructingVehicle;
        return $this;
    }
    /**
     * Add item to obstructingVehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicle $item
     * @return \StructType\VehicleObstruction
     */
    public function addToObstructingVehicle(\StructType\Vehicle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Vehicle) {
            throw new \InvalidArgumentException(sprintf('The obstructingVehicle property can only contain items of \StructType\Vehicle, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->obstructingVehicle[] = $item;
        return $this;
    }
    /**
     * Get vehicleObstructionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getVehicleObstructionExtension()
    {
        return $this->vehicleObstructionExtension;
    }
    /**
     * Set vehicleObstructionExtension value
     * @param \StructType\ExtensionType $vehicleObstructionExtension
     * @return \StructType\VehicleObstruction
     */
    public function setVehicleObstructionExtension(\StructType\ExtensionType $vehicleObstructionExtension = null)
    {
        $this->vehicleObstructionExtension = $vehicleObstructionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleObstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
