<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleMonitoringSubscriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Subscription Request for Vehicle Monitoring Service.
 * @subpackage Structs
 */
class VehicleMonitoringSubscriptionStructure extends AbstractSubscriptionStructure
{
    /**
     * The VehicleMonitoringRequest
     * Meta informations extracted from the WSDL
     * - ref: VehicleMonitoringRequest
     * @var \StructType\VehicleMonitoringRequestStructure
     */
    public $VehicleMonitoringRequest;
    /**
     * The IncrementalUpdates
     * @var bool
     */
    public $IncrementalUpdates;
    /**
     * The ChangeBeforeUpdates
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S",
     * "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ChangeBeforeUpdates;
    /**
     * The UpdateInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $UpdateInterval;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for VehicleMonitoringSubscriptionStructure
     * @uses VehicleMonitoringSubscriptionStructure::setVehicleMonitoringRequest()
     * @uses VehicleMonitoringSubscriptionStructure::setIncrementalUpdates()
     * @uses VehicleMonitoringSubscriptionStructure::setChangeBeforeUpdates()
     * @uses VehicleMonitoringSubscriptionStructure::setUpdateInterval()
     * @uses VehicleMonitoringSubscriptionStructure::setExtensions()
     * @param \StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest
     * @param bool $incrementalUpdates
     * @param string $changeBeforeUpdates
     * @param string $updateInterval
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest = null, $incrementalUpdates = null, $changeBeforeUpdates = null, $updateInterval = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVehicleMonitoringRequest($vehicleMonitoringRequest)
            ->setIncrementalUpdates($incrementalUpdates)
            ->setChangeBeforeUpdates($changeBeforeUpdates)
            ->setUpdateInterval($updateInterval)
            ->setExtensions($extensions);
    }
    /**
     * Get VehicleMonitoringRequest value
     * @return \StructType\VehicleMonitoringRequestStructure|null
     */
    public function getVehicleMonitoringRequest()
    {
        return $this->VehicleMonitoringRequest;
    }
    /**
     * Set VehicleMonitoringRequest value
     * @param \StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest
     * @return \StructType\VehicleMonitoringSubscriptionStructure
     */
    public function setVehicleMonitoringRequest(\StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest = null)
    {
        $this->VehicleMonitoringRequest = $vehicleMonitoringRequest;
        return $this;
    }
    /**
     * Get IncrementalUpdates value
     * @return bool|null
     */
    public function getIncrementalUpdates()
    {
        return $this->IncrementalUpdates;
    }
    /**
     * Set IncrementalUpdates value
     * @param bool $incrementalUpdates
     * @return \StructType\VehicleMonitoringSubscriptionStructure
     */
    public function setIncrementalUpdates($incrementalUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($incrementalUpdates) && !is_bool($incrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incrementalUpdates)), __LINE__);
        }
        $this->IncrementalUpdates = $incrementalUpdates;
        return $this;
    }
    /**
     * Get ChangeBeforeUpdates value
     * @return string|null
     */
    public function getChangeBeforeUpdates()
    {
        return $this->ChangeBeforeUpdates;
    }
    /**
     * Set ChangeBeforeUpdates value
     * @param string $changeBeforeUpdates
     * @return \StructType\VehicleMonitoringSubscriptionStructure
     */
    public function setChangeBeforeUpdates($changeBeforeUpdates = null)
    {
        // validation for constraint: string
        if (!is_null($changeBeforeUpdates) && !is_string($changeBeforeUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeBeforeUpdates)), __LINE__);
        }
        $this->ChangeBeforeUpdates = $changeBeforeUpdates;
        return $this;
    }
    /**
     * Get UpdateInterval value
     * @return string|null
     */
    public function getUpdateInterval()
    {
        return $this->UpdateInterval;
    }
    /**
     * Set UpdateInterval value
     * @param string $updateInterval
     * @return \StructType\VehicleMonitoringSubscriptionStructure
     */
    public function setUpdateInterval($updateInterval = null)
    {
        // validation for constraint: string
        if (!is_null($updateInterval) && !is_string($updateInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateInterval)), __LINE__);
        }
        $this->UpdateInterval = $updateInterval;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\VehicleMonitoringSubscriptionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleMonitoringSubscriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
